/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kew.mail;

import org.kuali.rice.core.api.config.property.ConfigContext;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.kuali.rice.kew.api.KewApiConstants;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;


/**
 * Quartz job for sending daily email reminders.
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public class DailyEmailJob implements Job {

	@Override
    public void execute(JobExecutionContext ctx) throws JobExecutionException {
		if (shouldExecute()) {
			KEWServiceLocator.getActionListEmailService().sendDailyReminder();
		}
	}

	protected boolean shouldExecute() {
		return Boolean.valueOf(ConfigContext.getCurrentContextConfig().getProperty(KewApiConstants.DAILY_EMAIL_ACTIVE));
	}

}
