/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kew.quicklinks.service.impl;

import org.kuali.rice.core.api.util.KeyValue;
import org.kuali.rice.kew.quicklinks.ActionListStats;
import org.kuali.rice.kew.quicklinks.InitiatedDocumentType;
import org.kuali.rice.kew.quicklinks.WatchedDocument;
import org.kuali.rice.kew.quicklinks.dao.QuickLinksDAO;
import org.kuali.rice.kew.quicklinks.service.QuickLinksService;

import java.util.List;


public class QuickLinksServiceImpl implements QuickLinksService {

    private QuickLinksDAO quickLinksDAO;

    @Override
	public List<ActionListStats> getActionListStats(String principalId) {
        return getQuickLinksDAO().getActionListStats(principalId);
    }

    @Override
	public List<InitiatedDocumentType> getInitiatedDocumentTypesList(String principalId) {
        return getQuickLinksDAO().getInitiatedDocumentTypesList(principalId);
    }

    @Override
	public List<KeyValue> getNamedSearches(String principalId) {
        return getQuickLinksDAO().getNamedSearches(principalId);
    }

    @Override
	public List<KeyValue> getRecentSearches(String principalId) {
        return getQuickLinksDAO().getRecentSearches(principalId);
    }

    @Override
	public List<WatchedDocument> getWatchedDocuments(String principalId) {
        return getQuickLinksDAO().getWatchedDocuments(principalId);
    }

    // BELOW ARE SPRING MANAGED PROPERTIES OF THIS BEAN
    public QuickLinksDAO getQuickLinksDAO() {
        return quickLinksDAO;
    }
    public void setQuickLinksDAO(QuickLinksDAO quickLinksDAO) {
        this.quickLinksDAO = quickLinksDAO;
    }

}
