/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kew.rule;

import org.kuali.rice.kew.rule.web.WebRuleBaseValues;


/**
 * Used by the {@link WebRuleBaseValues} to hold key-value-id data for {@link Field}s.
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public class KeyValueId {
	private String key;
	private String value;
	private String id;

	public KeyValueId() {

	}

	public KeyValueId(String key, String value, String id) {
		this.key = key;
		this.value = value;
		this.id = id;
	}

	public String getId() {
		return id;
	}

	public void setId(String id) {
		this.id = id;
	}

	public String getKey() {
		return key;
	}

	public void setKey(String key) {
		this.key = key;
	}

	public String getValue() {
		return value;
	}

	public void setValue(String value) {
		this.value = value;
	}

}
