/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kew.rule;

/**
 * A Rule wraps a rule definition (RuleBaseValues) and exposes it as a {@link RuleExpression}.
 * 'Rule' is defined as an interface to make the contract in the system clear and independent of implementation.
 * @see RuleBaseValues
 * @see RuleExpression
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public interface Rule extends RuleExpression {
    /**
     * @return the rule definition this rule is associated with
     */
    public org.kuali.rice.kew.api.rule.RuleContract getDefinition();
}
