/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kew.rule.dao;

import java.util.Collection;
import java.util.List;
import java.util.Map;

import org.kuali.rice.kew.rule.RuleDelegationBo;

public interface RuleDelegationDAO {

    public List<RuleDelegationBo> findByDelegateRuleId(String ruleId);
    public void save(RuleDelegationBo ruleDelegation);
    public List<RuleDelegationBo> findAllCurrentRuleDelegations();
    public void delete(String ruleDelegationId);
    public RuleDelegationBo findByRuleDelegationId(String ruleDelegationId);
    public List<RuleDelegationBo> findByResponsibilityIdWithCurrentRule(String responsibiliytId);
    public List<RuleDelegationBo> search(String parentRuleBaseVaueId, String parentResponsibilityId, String docTypeName, String ruleId, String ruleTemplateId, String ruleDescription, String workgroupId, String principalId, String delegationType, Boolean activeInd, Map extensionValues, String workflowIdDirective);
    public List<RuleDelegationBo> search(String parentRuleBaseVaueId, String parentResponsibilityId, String docTypeName, String ruleTemplateId, String ruleDescription, Collection<String> workgroupIds, String principalId, String delegationType, Boolean activeInd, Map extensionValues, Collection actionRequestCodes);

}
