/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kew.useroptions;

import org.kuali.rice.krad.data.jpa.IdClassBase;

/**
 * Composite primary key for the {@link UserOptions} class.
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public class UserOptionsId extends IdClassBase {

    private static final long serialVersionUID = -982957447172014416L;

    private String workflowId;
    private String optionId;

    public UserOptionsId() {}

    /**
     * Constructor to accept a workflow id and option id as parameters and instantiate the class.
     * @param workflowId the workflow id
     * @param optionId the user option id
     */
    public UserOptionsId(String workflowId, String optionId) {
        this.workflowId = workflowId;
        this.optionId = optionId;
    }

    /**
     * Returns the current option id
     * @return the current option id
     */
    public String getOptionId() {
        return optionId;
    }

    /**
     * Returns the current workflow id.
     * @return the current workflow id.
     */
    public String getWorkflowId() {
        return workflowId;
    }

}

