/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kim.lookup.valuefinder;

import org.kuali.rice.core.api.util.ConcreteKeyValue;
import org.kuali.rice.core.api.util.KeyValue;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.krad.keyvalues.KeyValuesBase;
import org.kuali.rice.kim.api.common.template.Template;

import java.util.ArrayList;
import java.util.List;

public class PermissionTemplateValuesFinder extends KeyValuesBase {

	@Override
	public List<KeyValue> getKeyValues() {
		List<Template> templates = KimApiServiceLocator.getPermissionService().getAllTemplates();
		List<KeyValue> result = new ArrayList<KeyValue>( templates.size() ); 
		for ( Template template : templates ) {
			result.add( new ConcreteKeyValue( template.getId(), template.getNamespaceCode() + " : " + template.getName() ) );
		}
		return result;
	}

}
