/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kim.rule.event.ui;

import org.kuali.rice.kim.bo.ui.GroupDocumentMember;
import org.kuali.rice.kim.document.IdentityManagementGroupDocument;
import org.kuali.rice.kim.rule.ui.AddGroupMemberRule;
import org.kuali.rice.krad.data.KradDataServiceLocator;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.rules.rule.BusinessRule;
import org.kuali.rice.krad.rules.rule.event.DocumentEventBase;

public class AddGroupMemberEvent extends DocumentEventBase {
	private GroupDocumentMember member;

	public AddGroupMemberEvent(String errorPathPrefix, IdentityManagementGroupDocument document) {
        super("Adding Group Member Document " + getDocumentId(document), errorPathPrefix, document);
    }

    public AddGroupMemberEvent(String errorPathPrefix, Document document, GroupDocumentMember member) {
        this(errorPathPrefix, (IdentityManagementGroupDocument) document);
        this.member = KradDataServiceLocator.getDataObjectService().copyInstance(member);
    }

    @Override
    public Class<? extends BusinessRule> getRuleInterfaceClass() {
        return AddGroupMemberRule.class;
    }

    @Override
    public boolean invokeRuleMethod(BusinessRule rule) {
        return ((AddGroupMemberRule) rule).processAddGroupMember(this);
    }

	/**
	 * @return the member
	 */
	public GroupDocumentMember getMember() {
		return this.member;
	}

	/**
	 * @param member the member to set
	 */
	public void setMember(GroupDocumentMember member) {
		this.member = member;
	}

}
