/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kns.datadictionary.exporter;

import java.util.Iterator;

import org.kuali.rice.kns.datadictionary.FieldDefinition;
import org.kuali.rice.kns.datadictionary.InquiryDefinition;
import org.kuali.rice.kns.datadictionary.InquirySectionDefinition;
import org.kuali.rice.kns.datadictionary.BusinessObjectEntry;
import org.kuali.rice.krad.datadictionary.exporter.ExportMap;

/**
 * InquiryMapBuilder
 * 
 * @deprecated Only used by KNS classes, no replacement.
 */
@Deprecated
public class InquiryMapBuilder {

    /**
     * Default constructor
     */
    public InquiryMapBuilder() {
    }


    /**
     * @param inquiry
     * @return ExportMap containing the standard entries for the entry's InquiryDefinition, or null if the given entry has no
     *         inquiryDefinition
     */
    public ExportMap buildInquiryMap(BusinessObjectEntry entry) {
    	try {
	        ExportMap inquiryMap = null;
	
	        if (entry.hasInquiryDefinition()) {
	            InquiryDefinition inquiryDefinition = entry.getInquiryDefinition();
	            inquiryMap = new ExportMap("inquiry");
	
	            inquiryMap.set("title", inquiryDefinition.getTitle());
	
	            inquiryMap.set(buildInquiryFieldsMap(inquiryDefinition));
	        }
	
	        return inquiryMap;
    	} catch ( Exception ex ) {
    		throw new RuntimeException( "Unable to build inquiry Map for " + entry, ex );
    	}
    }

    private ExportMap buildInquiryFieldsMap(InquiryDefinition inquiryDefinition) {
        ExportMap inquiryFieldsMap = new ExportMap("inquiryFields");

        for (Iterator i = inquiryDefinition.getInquirySections().iterator(); i.hasNext();) {
            InquirySectionDefinition inquirySection = (InquirySectionDefinition) i.next();
            for (Iterator iter = inquirySection.getInquiryFields().iterator(); iter.hasNext();) {
                FieldDefinition FieldDefinition = (FieldDefinition) iter.next();
                inquiryFieldsMap.set(MapperUtils.buildFieldMap(FieldDefinition));
            }
        }

        return inquiryFieldsMap;
    }
}
