/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kns.datadictionary.exporter;

import org.kuali.rice.krad.datadictionary.DataDictionaryEntryBase;
import org.kuali.rice.krad.datadictionary.PrimitiveAttributeDefinition;
import org.kuali.rice.krad.datadictionary.RelationshipDefinition;
import org.kuali.rice.krad.datadictionary.exporter.ExportMap;
import org.kuali.rice.krad.util.LegacyUtils;

/**
 * RelationshipsMapBuilder
 * 
 * @deprecated Only used by KNS classes, no replacement.
 */
@Deprecated
public class RelationshipsMapBuilder {

    /**
     * Default constructor
     */
    public RelationshipsMapBuilder() {
    }


    /**
     * @param entry
     * @return ExportMap containing the standard entries for the entry's RelationshipDefinitions
     */
    public ExportMap buildRelationshipsMap(DataDictionaryEntryBase entry) {
        ExportMap relationshipsMap = new ExportMap("relationships");

        for ( RelationshipDefinition relationship : entry.getRelationships() ) {
            //if in legacy context do not use any of the metadata injected stuff
            //this prevents a problem with duplicate entries that exists
            if(!(relationship.hasEmbeddedDataObjectMetadata() && LegacyUtils.isInLegacyContext())){
                relationshipsMap.set(buildRelationshipMap(relationship));
            }
        }

        return relationshipsMap;
    }

    private ExportMap buildRelationshipMap(RelationshipDefinition relationship) {
        ExportMap relationshipMap = new ExportMap(relationship.getObjectAttributeName());

        ExportMap attributesMap = new ExportMap("primitiveAttributes");

        int count = 0;
        for (PrimitiveAttributeDefinition primitiveAttributeDefinition : relationship.getPrimitiveAttributes()) {
            ExportMap attributeMap = new ExportMap(Integer.toString(count++));
            attributeMap.set("sourceName", primitiveAttributeDefinition.getSourceName());
            attributeMap.set("targetName", primitiveAttributeDefinition.getTargetName());

            attributesMap.set(attributeMap);
        }

        relationshipMap.set(attributesMap);

        return relationshipMap;
    }

}
