/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

// begin Kuali Foundation modification
package org.kuali.rice.kns.web.format;
// end Kuali Foundation modification

import org.kuali.rice.core.api.delegation.DelegationType;
import org.kuali.rice.core.web.format.Formatter;
import org.kuali.rice.kew.api.KewApiConstants;

/**
 * begin Kuali Foundation modification
 * This class is used to format boolean values.
 * end Kuali Foundation modification
 * @author Kuali Rice Team (rice.collab@kuali.org)
 *
 * @deprecated Only used by KNS classes, use KRAD.
 */
@Deprecated
public class DelegationTypeFormatter extends Formatter {
    private static final long serialVersionUID = -4109390572922205211L;
	/*
    protected Object convertToObject(String target) {
        if (Formatter.isEmptyValue(target))
            return null;

        String stringValue = target.getClass().isArray() ? unwrapString(target) : (String) target;
        stringValue = stringValue.trim().toUpperCase();

        return KewApiConstants.DELEGATION_TYPES.get(stringValue);
        if (TRUE_VALUES.contains(stringValue))
            return Boolean.TRUE;
        if (FALSE_VALUES.contains(stringValue))
            return Boolean.FALSE;

		// begin Kuali Foundation modification
		// was: throw new FormatException(CONVERT_MSG + stringValue);
        throw new FormatException("converting", RiceKeyConstants.ERROR_BOOLEAN, stringValue);
        // end Kuali Foundation modification
    }
*/
    @Override
    public Object format(Object target) {
        if (target == null) {
            return null;
        }
        // begin Kuali Foundation modification
        if (target instanceof String) {
        	DelegationType delegationType = DelegationType.fromCode(((String) target).trim().toUpperCase());
        	if (delegationType != null) {
        		return delegationType.getLabel();
        	} else {
        		return KewApiConstants.DELEGATION_BOTH_LABEL;
        	}
        } else {
            return "";
        }
    }
}
