/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kns.web.struts.action;

import org.apache.commons.lang.StringUtils;
import org.apache.struts.util.MessageResourcesFactory;
import org.apache.struts.util.PropertyMessageResources;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;

/**
 * @deprecated KNS Struts deprecated, use KRAD and the Spring MVC framework.
 */
@Deprecated
public class KualiPropertyMessageResources extends PropertyMessageResources {
    private static final long serialVersionUID = -7712311580595112293L;
    private HashMap kualiMessages;

    public KualiPropertyMessageResources(MessageResourcesFactory factory, String config) {
        super(factory, config);
    }

    public KualiPropertyMessageResources(MessageResourcesFactory factory, String config, boolean returnNull) {
        super(factory, config, returnNull);
    }

    @Override
    protected void loadLocale(String localeKey) {
        String initialConfig = config;
        String[] propertyFiles = config.split(",");
        for (String propertyFile : propertyFiles) {
            config = propertyFile;
            locales.remove(localeKey);
            super.loadLocale(localeKey);
        }
        config = initialConfig;
    }
    
    public Map getKualiProperties(String localeKey) {
        if (this.kualiMessages != null && !this.kualiMessages.isEmpty()) {
            return this.kualiMessages;
        } 
        localeKey = (localeKey == null) ? "" : localeKey;
        String localePrefix = localeKey + ".";
        
        this.loadLocale((localeKey == null) ? "" : localeKey);
        this.kualiMessages = new HashMap(this.messages.size());
        Set<String> keys = this.messages.keySet();
        for (String key : keys) {
            this.kualiMessages.put(StringUtils.substringAfter(key, localePrefix), this.messages.get(key));
        }
        return this.kualiMessages;
    }

}
