/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.ken.bo;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.persistence.Table;
import org.apache.commons.collections.CollectionUtils;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;
import org.kuali.rice.ken.api.notification.NotificationChannel;
import org.kuali.rice.ken.api.notification.NotificationChannelContract;
import org.kuali.rice.ken.api.notification.NotificationChannelReviewer;
import org.kuali.rice.ken.api.notification.NotificationListRecipient;
import org.kuali.rice.ken.api.notification.NotificationProducer;
import org.kuali.rice.ken.api.notification.UserChannelSubscription;
import org.kuali.rice.ken.bo.NotificationChannelReviewerBo;
import org.kuali.rice.ken.bo.NotificationProducerBo;
import org.kuali.rice.ken.bo.NotificationRecipientListBo;
import org.kuali.rice.ken.bo.UserChannelSubscriptionBo;
import org.kuali.rice.krad.bo.PersistableBusinessObjectBase;
import org.kuali.rice.krad.data.jpa.PortableSequenceGenerator;
import org.kuali.rice.krad.data.jpa.converters.BooleanYNConverter;

@Entity
@Table(name="KREN_CHNL_T")
public class NotificationChannelBo
extends PersistableBusinessObjectBase
implements NotificationChannelContract,
PersistenceWeaved,
PersistenceObject,
PersistenceWeavedFetchGroups,
PersistenceWeavedChangeTracking {
    @Id
    @GeneratedValue(generator="KREN_CHNL_S")
    @PortableSequenceGenerator(name="KREN_CHNL_S")
    @Column(name="CHNL_ID")
    private Long id;
    @Column(name="NM", nullable=false)
    private String name;
    @Column(name="DESC_TXT", nullable=false)
    private String description;
    @Convert(converter=BooleanYNConverter.class)
    @Column(name="SUBSCRB_IND", nullable=false)
    private boolean subscribable;
    @OneToMany(cascade={CascadeType.REFRESH, CascadeType.DETACH, CascadeType.REMOVE, CascadeType.MERGE, CascadeType.PERSIST}, targetEntity=NotificationRecipientListBo.class, mappedBy="channel")
    @OrderBy(value="id ASC")
    private List<NotificationRecipientListBo> recipientLists;
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.REFRESH, CascadeType.DETACH, CascadeType.MERGE, CascadeType.PERSIST})
    @JoinTable(name="KREN_CHNL_PRODCR_T", joinColumns={@JoinColumn(name="CHNL_ID")}, inverseJoinColumns={@JoinColumn(name="PRODCR_ID")})
    @OrderBy(value="id ASC")
    private List<NotificationProducerBo> producers;
    @OneToMany(cascade={CascadeType.REFRESH, CascadeType.DETACH, CascadeType.REMOVE, CascadeType.MERGE, CascadeType.PERSIST}, targetEntity=NotificationChannelReviewerBo.class, mappedBy="channel")
    @OrderBy(value="id ASC")
    private List<NotificationChannelReviewerBo> reviewers;
    @OneToMany(cascade={CascadeType.REFRESH, CascadeType.DETACH, CascadeType.REMOVE, CascadeType.MERGE, CascadeType.PERSIST}, targetEntity=UserChannelSubscriptionBo.class, mappedBy="channel")
    @OrderBy(value="id ASC")
    private List<UserChannelSubscriptionBo> subscriptions;
    static final long serialVersionUID = -7059916274848904998L;

    public NotificationChannelBo() {
        this.reviewers = new ArrayList<NotificationChannelReviewerBo>();
        this.subscriptions = new ArrayList<UserChannelSubscriptionBo>();
        this.recipientLists = new ArrayList<NotificationRecipientListBo>();
        this.producers = new ArrayList<NotificationProducerBo>();
    }

    public List<NotificationRecipientListBo> getRecipientLists() {
        return this._persistence_get_recipientLists();
    }

    public void setRecipientLists(List<NotificationRecipientListBo> recipientLists) {
        this._persistence_set_recipientLists(recipientLists);
    }

    public void addRecipientList(NotificationRecipientListBo recipientList) {
        this._persistence_get_recipientLists().add(recipientList);
    }

    public void removeRecipientList(NotificationRecipientListBo recipientList) {
        this._persistence_get_recipientLists().remove((Object)recipientList);
    }

    public String getDescription() {
        return this._persistence_get_description();
    }

    public void setDescription(String description) {
        this._persistence_set_description(description);
    }

    public Long getId() {
        return this._persistence_get_id();
    }

    public void setId(Long id) {
        this._persistence_set_id(id);
    }

    public String getName() {
        return this._persistence_get_name();
    }

    public void setName(String name) {
        this._persistence_set_name(name);
    }

    public boolean isSubscribable() {
        return this._persistence_get_subscribable();
    }

    public void setSubscribable(boolean subscribable) {
        this._persistence_set_subscribable(subscribable);
    }

    public List<NotificationProducerBo> getProducers() {
        return this._persistence_get_producers();
    }

    public void setProducers(List<NotificationProducerBo> producers) {
        this._persistence_set_producers(producers);
    }

    public List<NotificationChannelReviewerBo> getReviewers() {
        return this._persistence_get_reviewers();
    }

    public void setReviewers(List<NotificationChannelReviewerBo> reviewers) {
        this._persistence_set_reviewers(reviewers);
    }

    public List<UserChannelSubscriptionBo> getSubscriptions() {
        return this._persistence_get_subscriptions();
    }

    public void setSubscriptions(List<UserChannelSubscriptionBo> subscriptions) {
        this._persistence_set_subscriptions(subscriptions);
    }

    public boolean equals(Object obj) {
        NotificationChannelBo channelToCompare = (NotificationChannelBo)((Object)obj);
        return this.getId().equals(channelToCompare.getId());
    }

    public int hashCode() {
        return this._persistence_get_id() != null ? this._persistence_get_id().hashCode() : 0;
    }

    public static NotificationChannel to(NotificationChannelBo bo) {
        if (bo == null) {
            return null;
        }
        return NotificationChannel.Builder.create((NotificationChannelContract)bo).build();
    }

    public static NotificationChannelBo from(NotificationChannel im) {
        if (im == null) {
            return null;
        }
        NotificationChannelBo bo = new NotificationChannelBo();
        bo.setId(im.getId());
        bo.setVersionNumber(im.getVersionNumber());
        bo.setObjectId(im.getObjectId());
        bo.setName(im.getName());
        bo.setDescription(im.getDescription());
        bo.setSubscribable(im.isSubscribable());
        ArrayList<NotificationRecipientListBo> tempRecipientLists = new ArrayList<NotificationRecipientListBo>();
        if (CollectionUtils.isNotEmpty((Collection)im.getRecipientLists())) {
            for (Object listRecipient : im.getRecipientLists()) {
                tempRecipientLists.add(NotificationRecipientListBo.from((NotificationListRecipient)listRecipient));
            }
            bo.setRecipientLists(tempRecipientLists);
        }
        ArrayList<NotificationProducerBo> tempProducers = new ArrayList<NotificationProducerBo>();
        if (CollectionUtils.isNotEmpty((Collection)im.getProducers())) {
            for (Object producer : im.getProducers()) {
                tempProducers.add(NotificationProducerBo.from((NotificationProducer)producer));
            }
            bo.setProducers(tempProducers);
        }
        ArrayList<NotificationChannelReviewerBo> tempReviewers = new ArrayList<NotificationChannelReviewerBo>();
        if (CollectionUtils.isNotEmpty((Collection)im.getReviewers())) {
            for (NotificationChannelReviewer reviewer : im.getReviewers()) {
                tempReviewers.add(NotificationChannelReviewerBo.from(reviewer));
            }
            bo.setReviewers(tempReviewers);
        }
        ArrayList<UserChannelSubscriptionBo> tempSubscriptions = new ArrayList<UserChannelSubscriptionBo>();
        if (CollectionUtils.isNotEmpty((Collection)im.getSubscriptions())) {
            for (UserChannelSubscription subscription : im.getSubscriptions()) {
                tempSubscriptions.add(UserChannelSubscriptionBo.from(subscription));
            }
            bo.setSubscriptions(tempSubscriptions);
        }
        return bo;
    }

    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        this._persistence_listener = null;
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new NotificationChannelBo(persistenceObject);
    }

    public NotificationChannelBo(PersistenceObject persistenceObject) {
        super(persistenceObject);
    }

    public Object _persistence_get(String string) {
        if (string == "subscriptions") {
            return this.subscriptions;
        }
        if (string == "recipientLists") {
            return this.recipientLists;
        }
        if (string == "name") {
            return this.name;
        }
        if (string == "description") {
            return this.description;
        }
        if (string == "id") {
            return this.id;
        }
        if (string == "subscribable") {
            return this.subscribable;
        }
        if (string == "reviewers") {
            return this.reviewers;
        }
        if (string == "producers") {
            return this.producers;
        }
        return super._persistence_get(string);
    }

    public void _persistence_set(String string, Object object) {
        if (string == "subscriptions") {
            this.subscriptions = (List)object;
            return;
        }
        if (string == "recipientLists") {
            this.recipientLists = (List)object;
            return;
        }
        if (string == "name") {
            this.name = (String)object;
            return;
        }
        if (string == "description") {
            this.description = (String)object;
            return;
        }
        if (string == "id") {
            this.id = (Long)object;
            return;
        }
        if (string == "subscribable") {
            this.subscribable = (Boolean)object;
            return;
        }
        if (string == "reviewers") {
            this.reviewers = (List)object;
            return;
        }
        if (string == "producers") {
            this.producers = (List)object;
            return;
        }
        super._persistence_set(string, object);
    }

    public List _persistence_get_subscriptions() {
        this._persistence_checkFetched("subscriptions");
        return this.subscriptions;
    }

    public void _persistence_set_subscriptions(List list) {
        this._persistence_checkFetchedForSet("subscriptions");
        this._persistence_propertyChange("subscriptions", this.subscriptions, list);
        this.subscriptions = list;
    }

    public List _persistence_get_recipientLists() {
        this._persistence_checkFetched("recipientLists");
        return this.recipientLists;
    }

    public void _persistence_set_recipientLists(List list) {
        this._persistence_checkFetchedForSet("recipientLists");
        this._persistence_propertyChange("recipientLists", this.recipientLists, list);
        this.recipientLists = list;
    }

    public String _persistence_get_name() {
        this._persistence_checkFetched("name");
        return this.name;
    }

    public void _persistence_set_name(String string) {
        this._persistence_checkFetchedForSet("name");
        this._persistence_propertyChange("name", this.name, string);
        this.name = string;
    }

    public String _persistence_get_description() {
        this._persistence_checkFetched("description");
        return this.description;
    }

    public void _persistence_set_description(String string) {
        this._persistence_checkFetchedForSet("description");
        this._persistence_propertyChange("description", this.description, string);
        this.description = string;
    }

    public Long _persistence_get_id() {
        this._persistence_checkFetched("id");
        return this.id;
    }

    public void _persistence_set_id(Long l) {
        this._persistence_checkFetchedForSet("id");
        this._persistence_propertyChange("id", this.id, l);
        this.id = l;
    }

    public boolean _persistence_get_subscribable() {
        this._persistence_checkFetched("subscribable");
        return this.subscribable;
    }

    public void _persistence_set_subscribable(boolean bl) {
        this._persistence_checkFetchedForSet("subscribable");
        this._persistence_propertyChange("subscribable", new Boolean(this.subscribable), new Boolean(bl));
        this.subscribable = bl;
    }

    public List _persistence_get_reviewers() {
        this._persistence_checkFetched("reviewers");
        return this.reviewers;
    }

    public void _persistence_set_reviewers(List list) {
        this._persistence_checkFetchedForSet("reviewers");
        this._persistence_propertyChange("reviewers", this.reviewers, list);
        this.reviewers = list;
    }

    public List _persistence_get_producers() {
        this._persistence_checkFetched("producers");
        return this.producers;
    }

    public void _persistence_set_producers(List list) {
        this._persistence_checkFetchedForSet("producers");
        this._persistence_propertyChange("producers", this.producers, list);
        this.producers = list;
    }
}

