/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.impl.document;

import javax.xml.namespace.QName;
import org.kuali.rice.core.api.exception.RiceIllegalArgumentException;
import org.kuali.rice.kew.api.document.DocumentProcessingOptions;
import org.kuali.rice.kew.api.document.DocumentProcessingQueue;
import org.kuali.rice.ksb.api.messaging.AsyncCapableService;
import org.kuali.rice.ksb.api.messaging.CallMetadata;

final class DocumentProcessingQueueAsyncCapableImpl
implements DocumentProcessingQueue {
    private final AsyncCapableService asyncCapableService;
    private final DocumentProcessingQueue documentProcessingQueue;
    private final QName qname;
    private final String applicationId;

    DocumentProcessingQueueAsyncCapableImpl(AsyncCapableService asyncCapableService, DocumentProcessingQueue documentProcessingQueue, QName qname, String applicationId) {
        if (asyncCapableService == null) {
            throw new IllegalArgumentException("asyncCapableService is null");
        }
        if (documentProcessingQueue == null) {
            throw new IllegalArgumentException("documentProcessingQueue is null");
        }
        if (qname == null) {
            throw new IllegalArgumentException("qname is null");
        }
        this.asyncCapableService = asyncCapableService;
        this.documentProcessingQueue = documentProcessingQueue;
        this.qname = qname;
        this.applicationId = applicationId;
    }

    public void process(String documentId) throws RiceIllegalArgumentException {
        this.asyncCapableService.executeCall(this.qname, this.applicationId, documentId, null, new CallMetadata("process", new Class[]{String.class}, new Object[]{documentId}), () -> this.documentProcessingQueue.process(documentId));
    }

    public void processWithOptions(String documentId, DocumentProcessingOptions options) throws RiceIllegalArgumentException {
        this.asyncCapableService.executeCall(this.qname, this.applicationId, documentId, options != null ? options.toString() : null, new CallMetadata("processWithOptions", new Class[]{String.class, DocumentProcessingOptions.class}, new Object[]{documentId, options}), () -> this.documentProcessingQueue.processWithOptions(documentId, options));
    }
}

