/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.xml;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.rice.core.api.CoreApiServiceLocator;
import org.kuali.rice.core.api.util.xml.SafeXmlUtils;
import org.kuali.rice.core.api.util.xml.XmlException;
import org.kuali.rice.core.api.util.xml.XmlHelper;
import org.kuali.rice.core.api.util.xml.XmlJotter;
import org.kuali.rice.kew.api.KewApiConstants;
import org.kuali.rice.kew.api.WorkflowRuntimeException;
import org.kuali.rice.kew.api.exception.InvalidParentDocTypeException;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kew.doctype.ApplicationDocumentStatus;
import org.kuali.rice.kew.doctype.ApplicationDocumentStatusCategory;
import org.kuali.rice.kew.doctype.DocumentTypeAttributeBo;
import org.kuali.rice.kew.doctype.DocumentTypePolicy;
import org.kuali.rice.kew.doctype.bo.DocumentType;
import org.kuali.rice.kew.document.DocumentTypeMaintainable;
import org.kuali.rice.kew.engine.node.ActivationTypeEnum;
import org.kuali.rice.kew.engine.node.BranchPrototype;
import org.kuali.rice.kew.engine.node.NodeType;
import org.kuali.rice.kew.engine.node.ProcessDefinitionBo;
import org.kuali.rice.kew.engine.node.RoleNode;
import org.kuali.rice.kew.engine.node.RouteNode;
import org.kuali.rice.kew.engine.node.RouteNodeConfigParam;
import org.kuali.rice.kew.export.KewExportDataSet;
import org.kuali.rice.kew.role.RoleRouteModule;
import org.kuali.rice.kew.rule.bo.RuleAttribute;
import org.kuali.rice.kew.rule.bo.RuleTemplateBo;
import org.kuali.rice.kew.rule.xmlrouting.XPathHelper;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.kuali.rice.kew.util.Utilities;
import org.kuali.rice.kim.api.group.Group;
import org.kuali.rice.kim.api.group.GroupService;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.kns.maintenance.Maintainable;
import org.kuali.rice.kns.util.MaintenanceUtils;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.exception.GroupNotFoundException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class DocumentTypeXmlParser {
    private static final Logger LOG = LogManager.getLogger(DocumentTypeXmlParser.class);
    private static final String NEXT_NODE_EXP = "./@nextNode";
    private static final String PARENT_NEXT_NODE_EXP = "../@nextNode";
    private static final String NEXT_DOC_STATUS_EXP = "./@nextAppDocStatus";
    private static final String DEFAULT_ACTIVATION_TYPE = "S";
    private Map nodesMap;
    private XPath xpath;
    private Group defaultExceptionWorkgroup;

    protected XPath getXPath() {
        if (this.xpath == null) {
            this.xpath = XPathHelper.newXPath();
        }
        return this.xpath;
    }

    public List<DocumentType> parseDocumentTypes(InputStream input) throws SAXException, IOException, ParserConfigurationException, XPathExpressionException, WorkflowException, GroupNotFoundException {
        Document routeDocument = XmlHelper.trimXml((InputStream)input);
        HashMap<String, DocumentType> documentTypesByName = new HashMap<String, DocumentType>();
        for (DocumentType type : this.parseAllDocumentTypes(routeDocument)) {
            documentTypesByName.put(type.getName(), type);
        }
        return new ArrayList<DocumentType>(documentTypesByName.values());
    }

    private List<DocumentType> parseAllDocumentTypes(Document routeDocument) throws SAXException, IOException, ParserConfigurationException, XPathExpressionException, WorkflowException, GroupNotFoundException {
        HashMap<String, ArrayList<DocTypeNode>> pendingChildDocs = new HashMap<String, ArrayList<DocTypeNode>>();
        HashMap<String, ArrayList<String>> pendingChildNames = new HashMap<String, ArrayList<String>>();
        ArrayList docInitStack = new ArrayList();
        ArrayList<DocTypeNode> initialList = new ArrayList<DocTypeNode>();
        ArrayList<DocumentType> docTypeBeans = new ArrayList<DocumentType>();
        this.xpath = XPathHelper.newXPath();
        NodeList initialNodes = (NodeList)this.getXPath().evaluate("/data/documentTypes/documentType", routeDocument, XPathConstants.NODESET);
        for (int j = 0; j < initialNodes.getLength(); ++j) {
            Node documentTypeNode = initialNodes.item(j);
            boolean docIsStandard = true;
            try {
                String xpathModeExpression = "./@overwriteMode";
                if (XmlHelper.pathExists((XPath)this.xpath, (String)xpathModeExpression, (Object)documentTypeNode)) {
                    String overwriteMode = (String)this.getXPath().evaluate(xpathModeExpression, documentTypeNode, XPathConstants.STRING);
                    docIsStandard = !StringUtils.equalsIgnoreCase((String)"true", (String)overwriteMode);
                }
            }
            catch (XPathExpressionException xpee) {
                LOG.error("Error trying to check for 'overwriteMode' attribute on document type element", (Throwable)xpee);
                throw xpee;
            }
            initialList.add(new DocTypeNode(documentTypeNode, docIsStandard));
        }
        int stackLen = 0;
        DocTypeNode currDocNode = null;
        Iterator currentIter = initialList.iterator();
        while (stackLen >= 0) {
            if (currentIter.hasNext()) {
                String newParentName = null;
                currDocNode = (DocTypeNode)currentIter.next();
                try {
                    DocumentType docType = this.parseDocumentType(!currDocNode.isStandard, currDocNode.docNode);
                    docTypeBeans.add(docType);
                    newParentName = docType.getName();
                }
                catch (InvalidParentDocTypeException exc) {
                    ArrayList<DocTypeNode> tempList = null;
                    ArrayList<String> tempStrList = null;
                    String parentName = exc.getParentName();
                    String childName = exc.getChildName();
                    if (parentName == null || childName == null) {
                        throw exc;
                    }
                    tempList = (ArrayList<DocTypeNode>)pendingChildDocs.get(parentName);
                    tempStrList = (ArrayList<String>)pendingChildNames.get(parentName);
                    if (tempList == null) {
                        tempList = new ArrayList<DocTypeNode>();
                        tempStrList = new ArrayList<String>();
                        pendingChildDocs.put(parentName, tempList);
                        pendingChildNames.put(parentName, tempStrList);
                    }
                    tempList.add(currDocNode);
                    tempStrList.add(childName);
                }
                List childrenToProcess = (List)pendingChildDocs.remove(newParentName);
                pendingChildNames.remove(newParentName);
                if (childrenToProcess == null) continue;
                LOG.info("'" + newParentName + "' has children that were delayed; now processing them...");
                ++stackLen;
                docInitStack.add(currentIter);
                currentIter = childrenToProcess.iterator();
                continue;
            }
            currentIter = --stackLen >= 0 ? (Iterator)docInitStack.remove(stackLen) : null;
        }
        if (pendingChildDocs.size() > 0) {
            StringBuilder errMsg = new StringBuilder("Invalid parent document types: ");
            for (String currParent : pendingChildNames.keySet()) {
                errMsg.append("Invalid parent doc type '").append(currParent).append("' is needed by child doc types ");
                Iterator failedChildren = ((List)pendingChildNames.get(currParent)).iterator();
                while (failedChildren.hasNext()) {
                    String currChild = (String)failedChildren.next();
                    errMsg.append('\'').append(currChild).append(failedChildren.hasNext() ? "', " : "'; ");
                }
            }
            throw new InvalidParentDocTypeException(null, null, errMsg.toString());
        }
        return docTypeBeans;
    }

    private DocumentType parseDocumentType(boolean isOverwrite, Node documentTypeNode) throws SAXException, IOException, ParserConfigurationException, XPathExpressionException, WorkflowException, GroupNotFoundException {
        DocumentType documentType = this.getFullDocumentType(isOverwrite, documentTypeNode);
        this.nodesMap = null;
        this.xpath = null;
        this.defaultExceptionWorkgroup = null;
        LOG.debug("Saving document type " + documentType.getName());
        return this.routeDocumentType(documentType);
    }

    private DocumentType getFullDocumentType(boolean isOverwrite, Node documentTypeNode) throws XPathExpressionException, GroupNotFoundException, XmlException, WorkflowException, SAXException, IOException, ParserConfigurationException {
        NodeList securityList;
        NodeList attributeList;
        DocumentType documentType = this.getDocumentType(isOverwrite, documentTypeNode);
        NodeList policiesList = (NodeList)this.getXPath().evaluate("./policies", documentTypeNode, XPathConstants.NODESET);
        if (policiesList.getLength() > 1) {
            throw new XmlException("More than one policies node is present in a document type node");
        }
        if (policiesList.getLength() > 0) {
            NodeList policyNodes = (NodeList)this.getXPath().evaluate("./policy", policiesList.item(0), XPathConstants.NODESET);
            documentType.setDocumentTypePolicies(this.getDocumentTypePolicies(policyNodes, documentType));
        }
        if ((attributeList = (NodeList)this.getXPath().evaluate("./attributes", documentTypeNode, XPathConstants.NODESET)).getLength() > 1) {
            throw new XmlException("More than one attributes node is present in a document type node");
        }
        if (attributeList.getLength() > 0) {
            NodeList attributeNodes = (NodeList)this.getXPath().evaluate("./attribute", attributeList.item(0), XPathConstants.NODESET);
            documentType.setDocumentTypeAttributes(this.getDocumentTypeAttributes(attributeNodes, documentType));
        }
        if ((securityList = (NodeList)this.getXPath().evaluate("./security", documentTypeNode, XPathConstants.NODESET)).getLength() > 1) {
            throw new XmlException("More than one security node is present in a document type node");
        }
        if (securityList.getLength() > 0) {
            try {
                Node securityNode = securityList.item(0);
                String securityText = XmlJotter.jotNode((Node)securityNode);
                documentType.setDocumentTypeSecurityXml(securityText);
            }
            catch (Exception e) {
                throw new XmlException((Throwable)e);
            }
        }
        this.parseStructure(isOverwrite, documentTypeNode, documentType, new RoutePathContext());
        return documentType;
    }

    private void parseStructure(boolean isOverwrite, Node documentTypeNode, DocumentType documentType, RoutePathContext context) throws XPathExpressionException, XmlException, GroupNotFoundException {
        NodeList processNodes;
        boolean hasRoutePathsElement = false;
        try {
            hasRoutePathsElement = XmlHelper.pathExists((XPath)this.xpath, (String)"./routePaths", (Object)documentTypeNode);
        }
        catch (XPathExpressionException xpee) {
            LOG.error("Error obtaining document type routePaths", (Throwable)xpee);
            throw xpee;
        }
        boolean hasRouteNodesElement = false;
        try {
            hasRouteNodesElement = XmlHelper.pathExists((XPath)this.xpath, (String)"./routeNodes", (Object)documentTypeNode);
        }
        catch (XPathExpressionException xpee) {
            LOG.error("Error obtaining document type routeNodes", (Throwable)xpee);
            throw xpee;
        }
        if (isOverwrite) {
            if (!hasRouteNodesElement && !hasRoutePathsElement) {
                return;
            }
            if (hasRouteNodesElement && hasRoutePathsElement) {
                documentType.setProcesses(new ArrayList());
            } else if (!hasRouteNodesElement || !hasRoutePathsElement) {
                throw new XmlException("A overwriting document type ingestion can not have only one of the routePaths and routeNodes elements.  Either both or neither should be defined.");
            }
        }
        try {
            if (!XmlHelper.pathExists((XPath)this.xpath, (String)"./routePaths/routePath", (Object)documentTypeNode)) {
                if (hasRoutePathsElement) {
                    this.createEmptyProcess(documentType);
                }
                return;
            }
            processNodes = (NodeList)this.getXPath().evaluate("./routePaths/routePath", documentTypeNode, XPathConstants.NODESET);
        }
        catch (XPathExpressionException xpee) {
            LOG.error("Error obtaining document type routePaths", (Throwable)xpee);
            throw xpee;
        }
        this.createProcesses(processNodes, documentType);
        NodeList nodeList = null;
        try {
            nodeList = (NodeList)this.getXPath().evaluate("./routePaths/routePath/start", documentTypeNode, XPathConstants.NODESET);
        }
        catch (XPathExpressionException xpee) {
            LOG.error("Error obtaining document type routePath start", (Throwable)xpee);
            throw xpee;
        }
        if (nodeList.getLength() > 1) {
            throw new XmlException("More than one start node is present in route path");
        }
        if (nodeList.getLength() == 0) {
            throw new XmlException("No start node is present in route path");
        }
        try {
            nodeList = (NodeList)this.getXPath().evaluate(".//routeNodes", documentTypeNode, XPathConstants.NODESET);
        }
        catch (XPathExpressionException xpee) {
            LOG.error("Error obtaining document type routeNodes", (Throwable)xpee);
            throw xpee;
        }
        if (nodeList.getLength() > 1) {
            throw new XmlException("More than one routeNodes node is present in documentType node");
        }
        if (nodeList.getLength() == 0) {
            throw new XmlException("No routeNodes node is present in documentType node");
        }
        Node routeNodesNode = nodeList.item(0);
        this.checkForOrphanedRouteNodes(documentTypeNode, routeNodesNode);
        this.nodesMap = new HashMap();
        for (int index = 0; index < processNodes.getLength(); ++index) {
            RouteNode routeNode;
            String startName;
            Node processNode = processNodes.item(index);
            try {
                startName = (String)this.getXPath().evaluate("./start/@name", processNode, XPathConstants.STRING);
            }
            catch (XPathExpressionException xpee) {
                LOG.error("Error obtaining routePath start name attribute", (Throwable)xpee);
                throw xpee;
            }
            String processName = "PRIMARY";
            if (StringUtils.isEmpty((String)startName)) {
                try {
                    startName = (String)this.getXPath().evaluate("./@initialNode", processNode, XPathConstants.STRING);
                }
                catch (XPathExpressionException xpee) {
                    LOG.error("Error obtaining routePath initialNode attribute", (Throwable)xpee);
                    throw xpee;
                }
                try {
                    processName = (String)this.getXPath().evaluate("./@processName", processNode, XPathConstants.STRING);
                }
                catch (XPathExpressionException xpee) {
                    LOG.error("Error obtaining routePath processName attribute", (Throwable)xpee);
                    throw xpee;
                }
                if (StringUtils.isEmpty((String)startName)) {
                    throw new XmlException("Invalid routePath: no initialNode attribute defined!");
                }
            }
            if ((routeNode = this.createRouteNode(null, startName, processNode, routeNodesNode, documentType, context)) == null) continue;
            ProcessDefinitionBo process = documentType.getNamedProcess(processName);
            process.setInitialRouteNode(routeNode);
        }
    }

    private DocumentType getDocumentType(boolean isOverwrite, Node documentTypeNode) throws XPathExpressionException, GroupNotFoundException, XmlException, WorkflowException, SAXException, IOException, ParserConfigurationException {
        DocumentType documentType;
        block97: {
            documentType = null;
            String documentTypeName = this.getDocumentTypeNameFromNode(documentTypeNode);
            DocumentType previousDocumentType = KEWServiceLocator.getDocumentTypeService().findByName(documentTypeName);
            if (isOverwrite) {
                documentType = this.generateNewDocumentTypeFromExisting(documentTypeName);
            }
            if (documentType == null) {
                documentType = new DocumentType();
            }
            documentType.setName(documentTypeName);
            String description = null;
            try {
                description = (String)this.getXPath().evaluate("./description", documentTypeNode, XPathConstants.STRING);
            }
            catch (XPathExpressionException xpee) {
                LOG.error("Error obtaining document type description", (Throwable)xpee);
                throw xpee;
            }
            if (StringUtils.isNotBlank((String)description)) {
                documentType.setDescription(description);
            } else if (!isOverwrite) {
                if (previousDocumentType != null && StringUtils.isNotBlank((String)previousDocumentType.getDescription())) {
                    description = previousDocumentType.getDescription();
                }
                documentType.setDescription(description);
            }
            String label = null;
            try {
                label = (String)this.getXPath().evaluate("./label", documentTypeNode, XPathConstants.STRING);
            }
            catch (XPathExpressionException xpee) {
                LOG.error("Error obtaining document type label", (Throwable)xpee);
                throw xpee;
            }
            if (StringUtils.isNotBlank((String)label)) {
                documentType.setLabel(label);
            } else if (!isOverwrite) {
                label = previousDocumentType != null && StringUtils.isNotBlank((String)previousDocumentType.getLabel()) ? previousDocumentType.getLabel() : "Undefined";
                documentType.setLabel(label);
            }
            try {
                if (XmlHelper.pathExists((XPath)this.xpath, (String)"./postProcessorName", (Object)documentTypeNode)) {
                    String postProcessor = (String)this.getXPath().evaluate("./postProcessorName", documentTypeNode, XPathConstants.STRING);
                    if (StringUtils.isEmpty((String)postProcessor)) {
                        documentType.setPostProcessorName("none");
                    } else {
                        documentType.setPostProcessorName((String)this.getXPath().evaluate("./postProcessorName", documentTypeNode, XPathConstants.STRING));
                    }
                }
            }
            catch (XPathExpressionException xpee) {
                LOG.error("Error obtaining document type postProcessorName", (Throwable)xpee);
                throw xpee;
            }
            try {
                String authorizer;
                if (XmlHelper.pathExists((XPath)this.xpath, (String)"./authorizer", (Object)documentTypeNode) && StringUtils.isNotBlank((String)(authorizer = (String)this.getXPath().evaluate("./authorizer", documentTypeNode, XPathConstants.STRING)))) {
                    documentType.setAuthorizer(authorizer);
                }
            }
            catch (XPathExpressionException xpee) {
                LOG.error("Error obtaining document type authorizer", (Throwable)xpee);
                throw xpee;
            }
            try {
                if (XmlHelper.pathExists((XPath)this.xpath, (String)"./docHandler", (Object)documentTypeNode)) {
                    documentType.setUnresolvedDocHandlerUrl((String)this.getXPath().evaluate("./docHandler", documentTypeNode, XPathConstants.STRING));
                }
            }
            catch (XPathExpressionException xpee) {
                LOG.error("Error obtaining document type docHandler", (Throwable)xpee);
                throw xpee;
            }
            String helpDefUrl = null;
            try {
                helpDefUrl = (String)this.getXPath().evaluate("./helpDefinitionURL", documentTypeNode, XPathConstants.STRING);
            }
            catch (XPathExpressionException xpee) {
                LOG.error("Error obtaining document type help definition url", (Throwable)xpee);
                throw xpee;
            }
            if (StringUtils.isNotBlank((String)helpDefUrl)) {
                documentType.setUnresolvedHelpDefinitionUrl(helpDefUrl);
            } else if (!isOverwrite) {
                if (previousDocumentType != null && StringUtils.isNotBlank((String)previousDocumentType.getUnresolvedHelpDefinitionUrl())) {
                    helpDefUrl = previousDocumentType.getUnresolvedHelpDefinitionUrl();
                }
                documentType.setUnresolvedHelpDefinitionUrl(helpDefUrl);
            }
            String docSearchHelpUrl = null;
            try {
                docSearchHelpUrl = (String)this.getXPath().evaluate("./docSearchHelpURL", documentTypeNode, XPathConstants.STRING);
            }
            catch (XPathExpressionException xpee) {
                LOG.error("Error obtaining document type document search help url", (Throwable)xpee);
                throw xpee;
            }
            if (StringUtils.isNotBlank((String)docSearchHelpUrl)) {
                documentType.setUnresolvedDocSearchHelpUrl(docSearchHelpUrl);
            } else if (!isOverwrite) {
                if (previousDocumentType != null && StringUtils.isNotBlank((String)previousDocumentType.getUnresolvedDocSearchHelpUrl())) {
                    docSearchHelpUrl = previousDocumentType.getUnresolvedDocSearchHelpUrl();
                }
                documentType.setUnresolvedDocSearchHelpUrl(docSearchHelpUrl);
            }
            try {
                if (XmlHelper.pathExists((XPath)this.xpath, (String)"./applicationId", (Object)documentTypeNode)) {
                    documentType.setActualApplicationId((String)this.getXPath().evaluate("./applicationId", documentTypeNode, XPathConstants.STRING));
                } else if (XmlHelper.pathExists((XPath)this.xpath, (String)"./serviceNamespace", (Object)documentTypeNode)) {
                    documentType.setActualApplicationId((String)this.getXPath().evaluate("./serviceNamespace", documentTypeNode, XPathConstants.STRING));
                    LOG.warn("serviceNamespace element was set on document type XML but is deprecated and will be removed in a future version, please use applicationId instead.");
                }
            }
            catch (XPathExpressionException xpee) {
                LOG.error("Error obtaining document type applicationId", (Throwable)xpee);
                throw xpee;
            }
            try {
                if (XmlHelper.pathExists((XPath)this.xpath, (String)"./notificationFromAddress", (Object)documentTypeNode)) {
                    documentType.setActualNotificationFromAddress((String)this.getXPath().evaluate("./notificationFromAddress", documentTypeNode, XPathConstants.STRING));
                }
            }
            catch (XPathExpressionException xpee) {
                LOG.error("Error obtaining document type notificationFromAddress", (Throwable)xpee);
                throw xpee;
            }
            try {
                if (XmlHelper.pathExists((XPath)this.xpath, (String)"./emailStylesheet", (Object)documentTypeNode)) {
                    documentType.setCustomEmailStylesheet((String)this.getXPath().evaluate("./emailStylesheet", documentTypeNode, XPathConstants.STRING));
                }
            }
            catch (XPathExpressionException xpee) {
                LOG.error("Error obtaining document type emailStylesheet", (Throwable)xpee);
                throw xpee;
            }
            documentType.setCurrentInd(Boolean.TRUE);
            String exceptionWg = null;
            String exceptionWgName = null;
            String exceptionWgNamespace = null;
            try {
                if (XmlHelper.pathExists((XPath)this.xpath, (String)"./defaultExceptionGroupName", (Object)documentTypeNode)) {
                    exceptionWgName = (String)this.getXPath().evaluate("./defaultExceptionGroupName", documentTypeNode, XPathConstants.STRING);
                    exceptionWgNamespace = (String)this.getXPath().evaluate("./defaultExceptionGroupName/@namespace", documentTypeNode, XPathConstants.STRING);
                    exceptionWg = exceptionWgName;
                } else {
                    exceptionWg = (String)this.getXPath().evaluate("./defaultExceptionWorkgroupName", documentTypeNode, XPathConstants.STRING);
                }
            }
            catch (XPathExpressionException xpee) {
                LOG.error("Error obtaining document type defaultExceptionGroupName", (Throwable)xpee);
                throw xpee;
            }
            if (StringUtils.isNotBlank((String)exceptionWg)) {
                if (StringUtils.isNotBlank((String)exceptionWgName)) {
                    exceptionWgName = Utilities.substituteConfigParameters(exceptionWgName).trim();
                    exceptionWgNamespace = Utilities.substituteConfigParameters(exceptionWgNamespace).trim();
                } else {
                    LOG.warn(new StringBuilder(160).append("Document Type XML is using deprecated element '").append("defaultExceptionWorkgroupName").append("', please use '").append("defaultExceptionGroupName").append("' instead.").toString());
                    exceptionWg = Utilities.substituteConfigParameters(exceptionWg);
                    exceptionWgName = Utilities.parseGroupName(exceptionWg);
                    exceptionWgNamespace = Utilities.parseGroupNamespaceCode(exceptionWg);
                }
                Group exceptionGroup = this.getGroupService().getGroupByNamespaceCodeAndName(exceptionWgNamespace, exceptionWgName);
                if (exceptionGroup == null) {
                    throw new WorkflowRuntimeException("Exception workgroup name " + exceptionWgName + " does not exist");
                }
                documentType.setDefaultExceptionWorkgroup(exceptionGroup);
                this.defaultExceptionWorkgroup = exceptionGroup;
            }
            try {
                if (XmlHelper.pathExists((XPath)this.xpath, (String)"./active", (Object)documentTypeNode)) {
                    documentType.setActive(Boolean.valueOf((String)this.getXPath().evaluate("./active", documentTypeNode, XPathConstants.STRING)));
                } else if (!isOverwrite) {
                    documentType.setActive(Boolean.TRUE);
                }
            }
            catch (XPathExpressionException xpee) {
                LOG.error("Error obtaining document type active flag", (Throwable)xpee);
                throw xpee;
            }
            boolean parentElementExists = false;
            try {
                parentElementExists = XmlHelper.pathExists((XPath)this.xpath, (String)"./parent", (Object)documentTypeNode);
            }
            catch (XPathExpressionException xpee) {
                LOG.error("Error obtaining document type parent", (Throwable)xpee);
                throw xpee;
            }
            if (parentElementExists) {
                String parentDocumentTypeName = null;
                try {
                    parentDocumentTypeName = (String)this.getXPath().evaluate("./parent", documentTypeNode, XPathConstants.STRING);
                }
                catch (XPathExpressionException xpee) {
                    LOG.error("Error obtaining document type parent", (Throwable)xpee);
                    throw xpee;
                }
                DocumentType parentDocumentType = KEWServiceLocator.getDocumentTypeService().findByName(parentDocumentTypeName);
                if (parentDocumentType == null) {
                    LOG.info("Parent document type '" + parentDocumentTypeName + "' could not be found; attempting to delay processing of '" + documentTypeName + "'...");
                    throw new InvalidParentDocTypeException(parentDocumentTypeName, documentTypeName, "Invalid parent document type: '" + parentDocumentTypeName + "'");
                }
                documentType.setDocTypeParentId(parentDocumentType.getDocumentTypeId());
            }
            try {
                if (XmlHelper.pathExists((XPath)this.xpath, (String)"./superUserGroupName", (Object)documentTypeNode)) {
                    documentType.setSuperUserWorkgroupNoInheritence(this.retrieveValidKimGroup("./superUserGroupName", documentTypeNode, false));
                } else if (XmlHelper.pathExists((XPath)this.xpath, (String)"./superUserWorkgroupName", (Object)documentTypeNode)) {
                    LOG.warn(new StringBuilder(160).append("Document Type XML is using deprecated element '").append("superUserWorkgroupName").append("', please use '").append("superUserGroupName").append("' instead.").toString());
                    documentType.setSuperUserWorkgroupNoInheritence(this.retrieveValidKimGroup("./superUserWorkgroupName", documentTypeNode, true));
                }
            }
            catch (XPathExpressionException xpee) {
                LOG.error("Error obtaining document type superUserGroupName", (Throwable)xpee);
                throw xpee;
            }
            String blanketWorkGroup = null;
            String blanketGroupName = null;
            String blanketNamespace = null;
            String blanketApprovePolicy = null;
            try {
                if (XmlHelper.pathExists((XPath)this.xpath, (String)"./blanketApproveGroupName", (Object)documentTypeNode)) {
                    blanketGroupName = (String)this.getXPath().evaluate("./blanketApproveGroupName", documentTypeNode, XPathConstants.STRING);
                    blanketNamespace = (String)this.getXPath().evaluate("./blanketApproveGroupName/@namespace", documentTypeNode, XPathConstants.STRING);
                    blanketWorkGroup = blanketGroupName;
                } else if (XmlHelper.pathExists((XPath)this.xpath, (String)"./blanketApproveWorkgroupName", (Object)documentTypeNode)) {
                    blanketWorkGroup = (String)this.getXPath().evaluate("./blanketApproveWorkgroupName", documentTypeNode, XPathConstants.STRING);
                }
            }
            catch (XPathExpressionException xpee) {
                LOG.error("Error obtaining document type blanketApproveGroupName", (Throwable)xpee);
                throw xpee;
            }
            try {
                if (XmlHelper.pathExists((XPath)this.xpath, (String)"./blanketApprovePolicy", (Object)documentTypeNode)) {
                    blanketApprovePolicy = (String)this.getXPath().evaluate("./blanketApprovePolicy", documentTypeNode, XPathConstants.STRING);
                }
            }
            catch (XPathExpressionException xpee) {
                LOG.error("Error obtaining document type blanketApprovePolicy", (Throwable)xpee);
                throw xpee;
            }
            if (StringUtils.isNotBlank((String)blanketWorkGroup) && StringUtils.isNotBlank(blanketApprovePolicy)) {
                throw new XmlException("Only one of the blanket approve xml tags can be set");
            }
            if (StringUtils.isNotBlank((String)blanketWorkGroup)) {
                if (isOverwrite) {
                    documentType.setBlanketApprovePolicy(null);
                }
                if (StringUtils.isNotBlank((String)blanketGroupName)) {
                    documentType.setBlanketApproveWorkgroup(this.retrieveValidKimGroupUsingGroupNameAndNamespace(blanketGroupName, blanketNamespace));
                } else {
                    LOG.warn(new StringBuilder(160).append("Document Type XML is using deprecated element '").append("blanketApproveWorkgroupName").append("', please use '").append("blanketApproveGroupName").append("' instead.").toString());
                    documentType.setBlanketApproveWorkgroup(this.retrieveValidKimGroupUsingUnparsedGroupName(blanketWorkGroup));
                }
            } else if (StringUtils.isNotBlank((String)blanketApprovePolicy)) {
                if (isOverwrite) {
                    documentType.setBlanketApproveWorkgroup(null);
                }
                documentType.setBlanketApprovePolicy(blanketApprovePolicy);
            }
            try {
                if (XmlHelper.pathExists((XPath)this.xpath, (String)"./reportingGroupName", (Object)documentTypeNode)) {
                    documentType.setReportingWorkgroup(this.retrieveValidKimGroup("./reportingGroupName", documentTypeNode, false));
                } else if (XmlHelper.pathExists((XPath)this.xpath, (String)"./reportingWorkgroupName", (Object)documentTypeNode)) {
                    LOG.warn(new StringBuilder(160).append("Document Type XML is using deprecated element '").append("reportingWorkgroupName").append("', please use '").append("reportingGroupName").append("' instead.").toString());
                    documentType.setReportingWorkgroup(this.retrieveValidKimGroup("./reportingWorkgroupName", documentTypeNode, true));
                }
            }
            catch (XPathExpressionException xpee) {
                LOG.error("Error obtaining document type reportingGroupName", (Throwable)xpee);
                throw xpee;
            }
            try {
                String version;
                if (!XmlHelper.pathExists((XPath)this.xpath, (String)"./routingVersion", (Object)documentTypeNode)) break block97;
                try {
                    version = (String)this.getXPath().evaluate("./routingVersion", documentTypeNode, XPathConstants.STRING);
                }
                catch (XPathExpressionException xpee) {
                    LOG.error("Error obtaining document type routingVersion", (Throwable)xpee);
                    throw xpee;
                }
                if (!version.equals("1") && !version.equals("2")) {
                    throw new WorkflowRuntimeException("Invalid routing version on document type: " + version);
                }
                documentType.setRoutingVersion(version);
            }
            catch (XPathExpressionException xpee) {
                LOG.error("Error obtaining document type routingVersion", (Throwable)xpee);
                throw xpee;
            }
        }
        ApplicationDocumentStatusParser.parseValidApplicationStatuses(documentType, documentTypeNode, this.getXPath());
        return documentType;
    }

    private Group retrieveValidKimGroup(String xpathExpression, Node documentTypeNode, boolean deprecatedGroupElement) throws XPathExpressionException, GroupNotFoundException {
        String groupName;
        String groupNamespace = null;
        try {
            groupName = (String)this.getXPath().evaluate(xpathExpression, documentTypeNode, XPathConstants.STRING);
            if (!deprecatedGroupElement) {
                groupNamespace = (String)this.getXPath().evaluate(xpathExpression + "/@namespace", documentTypeNode, XPathConstants.STRING);
            }
        }
        catch (XPathExpressionException xpee) {
            LOG.error("Error obtaining document type workgroup using xpath expression: " + xpathExpression, (Throwable)xpee);
            throw xpee;
        }
        return deprecatedGroupElement ? this.retrieveValidKimGroupUsingUnparsedGroupName(groupName) : this.retrieveValidKimGroupUsingGroupNameAndNamespace(groupName, groupNamespace);
    }

    private Group retrieveValidKimGroupUsingGroupNameAndNamespace(String groupName, String groupNamespace) throws GroupNotFoundException {
        groupName = Utilities.substituteConfigParameters(groupName).trim();
        groupNamespace = Utilities.substituteConfigParameters(groupNamespace).trim();
        return this.retrieveValidKimGroupUsingProcessedGroupNameAndNamespace(groupName, groupNamespace);
    }

    private Group retrieveValidKimGroupUsingUnparsedGroupName(String unparsedGroupName) throws GroupNotFoundException {
        unparsedGroupName = Utilities.substituteConfigParameters(unparsedGroupName);
        String groupName = Utilities.parseGroupName(unparsedGroupName);
        String groupNamespace = Utilities.parseGroupNamespaceCode(unparsedGroupName);
        return this.retrieveValidKimGroupUsingProcessedGroupNameAndNamespace(groupName, groupNamespace);
    }

    private Group retrieveValidKimGroupUsingProcessedGroupNameAndNamespace(String groupName, String groupNamespace) throws GroupNotFoundException {
        if (StringUtils.isBlank((String)groupNamespace) || StringUtils.isBlank((String)groupName)) {
            throw new GroupNotFoundException("Valid Workgroup could not be found... Namespace: " + groupNamespace + "  Name: " + groupName);
        }
        Group workgroup = this.getGroupService().getGroupByNamespaceCodeAndName(groupNamespace, groupName);
        if (workgroup == null) {
            throw new GroupNotFoundException("Valid Workgroup could not be found... Namespace: " + groupNamespace + "  Name: " + groupName);
        }
        return workgroup;
    }

    public DocumentType generateNewDocumentTypeFromExisting(String documentTypeName) throws SAXException, IOException, ParserConfigurationException, XPathExpressionException, GroupNotFoundException, WorkflowException {
        DocumentType docTypeFromDatabase = KEWServiceLocator.getDocumentTypeService().findByName(documentTypeName);
        if (docTypeFromDatabase != null) {
            KewExportDataSet kewExportDataSet = new KewExportDataSet();
            kewExportDataSet.getDocumentTypes().add(docTypeFromDatabase);
            byte[] xmlBytes = CoreApiServiceLocator.getXmlExporterService().export(kewExportDataSet.createExportDataSet());
            Document tempDocument = XmlHelper.trimXml((InputStream)new BufferedInputStream(new ByteArrayInputStream(xmlBytes)));
            Node documentTypeNode = (Node)this.getXPath().evaluate("/data/documentTypes/documentType", tempDocument, XPathConstants.NODE);
            return this.getFullDocumentType(false, documentTypeNode);
        }
        return null;
    }

    private DocumentType routeDocumentType(DocumentType documentType) {
        DocumentType docType = KEWServiceLocator.getDocumentTypeService().findByName(documentType.getName());
        if (docType != null) {
            DocumentTypeMaintainable docTypeMaintainable = new DocumentTypeMaintainable();
            docTypeMaintainable.setBusinessObject((PersistableBusinessObject)docType);
            docTypeMaintainable.setBoClass(docType.getClass());
            MaintenanceUtils.checkForLockingDocument((Maintainable)docTypeMaintainable, (boolean)true);
        }
        return KEWServiceLocator.getDocumentTypeService().versionAndSave(documentType);
    }

    private String getDocumentTypeNameFromNode(Node documentTypeNode) throws XPathExpressionException {
        try {
            return (String)this.getXPath().evaluate("./name", documentTypeNode, XPathConstants.STRING);
        }
        catch (XPathExpressionException xpee) {
            LOG.error("Error obtaining document type name", (Throwable)xpee);
            throw xpee;
        }
    }

    private void checkForOrphanedRouteNodes(Node documentTypeNode, Node routeNodesNode) throws XPathExpressionException, XmlException {
        NodeList nodesInPath = (NodeList)this.getXPath().evaluate("./routePaths/routePath//*/@name", documentTypeNode, XPathConstants.NODESET);
        ArrayList<String> nodeNamesInPath = new ArrayList<String>(nodesInPath.getLength());
        for (int index = 0; index < nodesInPath.getLength(); ++index) {
            Node nameNode = nodesInPath.item(index);
            nodeNamesInPath.add(nameNode.getNodeValue());
        }
        NodeList declaredNodes = (NodeList)this.getXPath().evaluate("./*/@name", routeNodesNode, XPathConstants.NODESET);
        ArrayList<String> declaredNodeNames = new ArrayList<String>(declaredNodes.getLength());
        for (int index = 0; index < declaredNodes.getLength(); ++index) {
            Node nameNode = declaredNodes.item(index);
            declaredNodeNames.add(nameNode.getNodeValue());
        }
        ArrayList<String> orphanedNodes = new ArrayList<String>();
        for (String declaredNode : declaredNodeNames) {
            boolean foundNode = false;
            for (String nodeInPath : nodeNamesInPath) {
                if (!nodeInPath.equals(declaredNode)) continue;
                foundNode = true;
                break;
            }
            if (foundNode) continue;
            orphanedNodes.add(declaredNode);
        }
        if (!orphanedNodes.isEmpty()) {
            Object message = "The following nodes were declared but never used: ";
            Iterator iterator = orphanedNodes.iterator();
            while (iterator.hasNext()) {
                String orphanedNode = (String)iterator.next();
                message = (String)message + orphanedNode + (iterator.hasNext() ? ", " : "");
            }
            throw new XmlException((String)message);
        }
    }

    private void createProcesses(NodeList processNodes, DocumentType documentType) {
        for (int index = 0; index < processNodes.getLength(); ++index) {
            Node processNode = processNodes.item(index);
            NamedNodeMap attributes = processNode.getAttributes();
            Node processNameNode = attributes.getNamedItem("processName");
            String processName = processNameNode == null ? null : processNameNode.getNodeValue();
            ProcessDefinitionBo process = new ProcessDefinitionBo();
            if (StringUtils.isEmpty((String)processName)) {
                process.setInitial(true);
                process.setName("PRIMARY");
            } else {
                process.setInitial(false);
                process.setName(processName);
            }
            process.setDocumentType(documentType);
            documentType.addProcess(process);
        }
    }

    private void createEmptyProcess(DocumentType documentType) {
        ProcessDefinitionBo process = new ProcessDefinitionBo();
        process.setInitial(true);
        process.setName("PRIMARY");
        process.setDocumentType(documentType);
        documentType.addProcess(process);
    }

    private RoutePathContext findNodeOnXPath(String nodeName, RoutePathContext context, Node routePathNode) throws XPathExpressionException, XmlException {
        while (context.nodeQName.length() > 1) {
            Node currentNode;
            context.nodeXPath = context.nodeXPath.substring(0, context.nodeXPath.lastIndexOf("//"));
            context.nodeQName = context.nodeQName.substring(0, context.nodeQName.lastIndexOf(":", context.nodeQName.lastIndexOf(":") - 1) + 1);
            if (StringUtils.isBlank((String)context.nodeQName)) {
                context.nodeQName = ":";
            }
            try {
                currentNode = (Node)this.getXPath().evaluate(context.nodeXPath + "//*[@name = '" + nodeName + "']", routePathNode, XPathConstants.NODE);
            }
            catch (XPathExpressionException xpee) {
                LOG.error("Error obtaining routePath for routeNode", (Throwable)xpee);
                throw xpee;
            }
            if (currentNode == null) continue;
            return context;
        }
        return context;
    }

    private RouteNode createRouteNode(RouteNode previousRouteNode, String nodeName, Node routePathNode, Node routeNodesNode, DocumentType documentType, RoutePathContext context) throws XPathExpressionException, XmlException, GroupNotFoundException {
        boolean hasNextDocStatus;
        boolean hasNextNodeAttrib;
        String localName;
        boolean nodeIsABranch;
        Node currentNode;
        if (nodeName == null) {
            return null;
        }
        context.nodeXPath = context.nodeXPath + "//*[@name = '" + nodeName + "']";
        context.nodeQName = context.nodeQName + nodeName + ":";
        try {
            currentNode = (Node)this.getXPath().evaluate(context.nodeXPath + "//*[@name = '" + nodeName + "']", routePathNode, XPathConstants.NODE);
            if (currentNode == null) {
                this.findNodeOnXPath(nodeName, context, routePathNode);
                currentNode = (Node)this.getXPath().evaluate(context.nodeXPath + "//*[@name = '" + nodeName + "']", routePathNode, XPathConstants.NODE);
            }
        }
        catch (XPathExpressionException xpee) {
            LOG.error("Error obtaining routePath for routeNode", (Throwable)xpee);
            throw xpee;
        }
        if (currentNode == null) {
            String message = "Next node '" + nodeName + "' for node '" + previousRouteNode.getRouteNodeName() + "' not found!";
            LOG.error(message);
            throw new XmlException(message);
        }
        context.nodeXPath = context.nodeXPath + "//*[@name = '" + nodeName + "']";
        context.nodeQName = context.nodeQName + nodeName + ":";
        LOG.debug("nodeQNme:" + context.nodeQName);
        try {
            nodeIsABranch = (Boolean)this.getXPath().evaluate("self::node()[local-name() = 'branch']", currentNode, XPathConstants.BOOLEAN);
        }
        catch (XPathExpressionException xpee) {
            LOG.error("Error testing whether node is a branch", (Throwable)xpee);
            throw xpee;
        }
        if (nodeIsABranch) {
            throw new XmlException("Next node cannot be a branch node");
        }
        try {
            localName = (String)this.getXPath().evaluate("local-name(.)", currentNode, XPathConstants.STRING);
        }
        catch (XPathExpressionException xpee) {
            LOG.error("Error obtaining node local-name", (Throwable)xpee);
            throw xpee;
        }
        RouteNode currentRouteNode = null;
        if (this.nodesMap.containsKey(context.nodeQName)) {
            currentRouteNode = (RouteNode)this.nodesMap.get(context.nodeQName);
        } else {
            String nodeExpression = ".//*[@name='" + nodeName + "']";
            currentRouteNode = this.makeRouteNodePrototype(localName, nodeName, nodeExpression, routeNodesNode, documentType, context);
        }
        if ("split".equalsIgnoreCase(localName)) {
            this.getSplitNextNodes(currentNode, routePathNode, currentRouteNode, routeNodesNode, documentType, this.cloneContext(context));
        }
        if (previousRouteNode != null) {
            previousRouteNode.getNextNodes().add(currentRouteNode);
            this.nodesMap.put(context.previousNodeQName, previousRouteNode);
            currentRouteNode.getPreviousNodes().add(previousRouteNode);
        }
        String nextNodeName = null;
        try {
            hasNextNodeAttrib = (Boolean)this.getXPath().evaluate(NEXT_NODE_EXP, currentNode, XPathConstants.BOOLEAN);
        }
        catch (XPathExpressionException xpee) {
            LOG.error("Error obtaining node nextNode attrib", (Throwable)xpee);
            throw xpee;
        }
        if (hasNextNodeAttrib) {
            if (!"split".equalsIgnoreCase(localName)) {
                try {
                    nextNodeName = (String)this.getXPath().evaluate(NEXT_NODE_EXP, currentNode, XPathConstants.STRING);
                }
                catch (XPathExpressionException xpee) {
                    LOG.error("Error obtaining node nextNode attrib", (Throwable)xpee);
                    throw xpee;
                }
                context.previousNodeQName = context.nodeQName;
                this.createRouteNode(currentRouteNode, nextNodeName, routePathNode, routeNodesNode, documentType, this.cloneContext(context));
            } else {
                this.nodesMap.put(context.nodeQName, currentRouteNode);
            }
        } else if (!"join".equalsIgnoreCase(localName)) {
            this.nodesMap.put(context.nodeQName, currentRouteNode);
        } else {
            boolean parentHasNextNodeAttrib;
            try {
                parentHasNextNodeAttrib = (Boolean)this.getXPath().evaluate(PARENT_NEXT_NODE_EXP, currentNode, XPathConstants.BOOLEAN);
            }
            catch (XPathExpressionException xpee) {
                LOG.error("Error obtaining parent node nextNode attrib", (Throwable)xpee);
                throw xpee;
            }
            if (parentHasNextNodeAttrib && !this.nodesMap.containsKey(context.nodeQName)) {
                try {
                    nextNodeName = (String)this.getXPath().evaluate(PARENT_NEXT_NODE_EXP, currentNode, XPathConstants.STRING);
                }
                catch (XPathExpressionException xpee) {
                    LOG.error("Error obtaining parent node nextNode attrib", (Throwable)xpee);
                    throw xpee;
                }
                context.previousNodeQName = context.nodeQName;
                this.createRouteNode(currentRouteNode, nextNodeName, routePathNode, routeNodesNode, documentType, this.cloneContext(context));
            } else {
                this.nodesMap.put(context.nodeQName, currentRouteNode);
            }
        }
        String nextDocStatusName = null;
        try {
            hasNextDocStatus = (Boolean)this.getXPath().evaluate(NEXT_DOC_STATUS_EXP, currentNode, XPathConstants.BOOLEAN);
        }
        catch (XPathExpressionException xpee) {
            LOG.error("Error obtaining node nextAppDocStatus attrib", (Throwable)xpee);
            throw xpee;
        }
        if (hasNextDocStatus) {
            try {
                nextDocStatusName = (String)this.getXPath().evaluate(NEXT_DOC_STATUS_EXP, currentNode, XPathConstants.STRING);
            }
            catch (XPathExpressionException xpee) {
                LOG.error("Error obtaining node nextNode attrib", (Throwable)xpee);
                throw xpee;
            }
            if (documentType.getValidApplicationStatuses() != null && documentType.getValidApplicationStatuses().size() > 0) {
                Iterator<ApplicationDocumentStatus> iter = documentType.getValidApplicationStatuses().iterator();
                boolean statusValidated = false;
                while (iter.hasNext()) {
                    ApplicationDocumentStatus myAppDocStat = iter.next();
                    if (nextDocStatusName.compareToIgnoreCase(myAppDocStat.getStatusName()) != 0) continue;
                    statusValidated = true;
                    break;
                }
                if (!statusValidated) {
                    XmlException xpee = new XmlException("AppDocStatus value " + nextDocStatusName + " not allowable.");
                    LOG.error("Error validating nextAppDocStatus name: " + nextDocStatusName + " against acceptable values.", (Throwable)xpee);
                    throw xpee;
                }
            }
            currentRouteNode.setNextDocStatus(nextDocStatusName);
        }
        return currentRouteNode;
    }

    private void getSplitNextNodes(Node splitNode, Node routePathNode, RouteNode splitRouteNode, Node routeNodesNode, DocumentType documentType, RoutePathContext context) throws XPathExpressionException, XmlException, GroupNotFoundException {
        NodeList splitBranchNodes;
        try {
            splitBranchNodes = (NodeList)this.getXPath().evaluate("./branch", splitNode, XPathConstants.NODESET);
        }
        catch (XPathExpressionException xpee) {
            LOG.error("Error obtaining split node branch", (Throwable)xpee);
            throw xpee;
        }
        String splitQName = context.nodeQName;
        String splitXPath = context.nodeXPath;
        for (int i = 0; i < splitBranchNodes.getLength(); ++i) {
            String name;
            String branchName;
            try {
                branchName = (String)this.getXPath().evaluate("./@name", splitBranchNodes.item(i), XPathConstants.STRING);
            }
            catch (XPathExpressionException xpee) {
                LOG.error("Error obtaining branch name attribute", (Throwable)xpee);
                throw xpee;
            }
            try {
                name = (String)this.getXPath().evaluate("./*[1]/@name", splitBranchNodes.item(i), XPathConstants.STRING);
            }
            catch (XPathExpressionException xpee) {
                LOG.error("Error obtaining first split branch node name", (Throwable)xpee);
                throw xpee;
            }
            context.nodeQName = splitQName + branchName + ":";
            context.nodeXPath = splitXPath + "//*[@name = '" + branchName + "']";
            context.branch = new BranchPrototype();
            context.branch.setName(branchName);
            context.previousNodeQName = splitQName;
            this.createRouteNode(splitRouteNode, name, routePathNode, routeNodesNode, documentType, this.cloneContext(context));
        }
    }

    private RouteNode makeRouteNodePrototype(String nodeTypeName, String nodeName, String nodeExpression, Node routeNodesNode, DocumentType documentType, RoutePathContext context) throws XPathExpressionException, GroupNotFoundException, XmlException {
        String localName;
        NodeList nodeList;
        try {
            nodeList = (NodeList)this.getXPath().evaluate(nodeExpression, routeNodesNode, XPathConstants.NODESET);
        }
        catch (XPathExpressionException xpee) {
            LOG.error("Error evaluating node expression: '" + nodeExpression + "'");
            throw xpee;
        }
        if (nodeList.getLength() > 1) {
            throw new XmlException("More than one node under routeNodes has the same name of '" + nodeName + "'");
        }
        if (nodeList.getLength() == 0) {
            throw new XmlException("No node definition was found with the name '" + nodeName + "'");
        }
        Node node = nodeList.item(0);
        RouteNode routeNode = new RouteNode();
        routeNode.setDocumentType(documentType);
        routeNode.setRouteNodeName((String)this.getXPath().evaluate("./@name", node, XPathConstants.STRING));
        routeNode.setContentFragment(XmlJotter.jotNode((Node)node));
        if (XmlHelper.pathExists((XPath)this.xpath, (String)"./activationType", (Object)node)) {
            routeNode.setActivationType(ActivationTypeEnum.parse((String)this.getXPath().evaluate("./activationType", node, XPathConstants.STRING)).getCode());
        } else {
            routeNode.setActivationType(DEFAULT_ACTIVATION_TYPE);
        }
        Group exceptionWorkgroup = this.defaultExceptionWorkgroup;
        String exceptionWg = null;
        String exceptionWorkgroupName = null;
        String exceptionWorkgroupNamespace = null;
        if (XmlHelper.pathExists((XPath)this.xpath, (String)"./exceptionGroupName", (Object)node)) {
            exceptionWorkgroupName = Utilities.substituteConfigParameters((String)this.getXPath().evaluate("./exceptionGroupName", node, XPathConstants.STRING)).trim();
            exceptionWorkgroupNamespace = Utilities.substituteConfigParameters((String)this.getXPath().evaluate("./exceptionGroupName/@namespace", node, XPathConstants.STRING)).trim();
        }
        if (StringUtils.isEmpty(exceptionWorkgroupName) && XmlHelper.pathExists((XPath)this.xpath, (String)"./exceptionWorkgroupName", (Object)node)) {
            LOG.warn(new StringBuilder(160).append("Document Type XML is using deprecated element '").append("exceptionWorkgroupName").append("', please use '").append("exceptionGroupName").append("' instead.").toString());
            exceptionWg = Utilities.substituteConfigParameters((String)this.getXPath().evaluate("./exceptionWorkgroupName", node, XPathConstants.STRING));
            exceptionWorkgroupName = Utilities.parseGroupName(exceptionWg);
            exceptionWorkgroupNamespace = Utilities.parseGroupNamespaceCode(exceptionWg);
        }
        if (StringUtils.isEmpty(exceptionWorkgroupName) && XmlHelper.pathExists((XPath)this.xpath, (String)"./exceptionWorkgroup", (Object)node)) {
            LOG.warn(new StringBuilder(160).append("Document Type XML is using deprecated element '").append("exceptionWorkgroup").append("', please use '").append("exceptionGroupName").append("' instead.").toString());
            exceptionWg = Utilities.substituteConfigParameters((String)this.getXPath().evaluate("./exceptionWorkgroup", node, XPathConstants.STRING));
            exceptionWorkgroupName = Utilities.parseGroupName(exceptionWg);
            exceptionWorkgroupNamespace = Utilities.parseGroupNamespaceCode(exceptionWg);
        }
        if (StringUtils.isEmpty(exceptionWorkgroupName) && routeNode.getDocumentType().getDefaultExceptionWorkgroup() != null) {
            exceptionWorkgroupName = routeNode.getDocumentType().getDefaultExceptionWorkgroup().getName();
            exceptionWorkgroupNamespace = routeNode.getDocumentType().getDefaultExceptionWorkgroup().getNamespaceCode();
        }
        if (StringUtils.isNotEmpty((String)exceptionWorkgroupName) && StringUtils.isNotEmpty(exceptionWorkgroupNamespace) ? (exceptionWorkgroup = this.getGroupService().getGroupByNamespaceCodeAndName(exceptionWorkgroupNamespace, exceptionWorkgroupName)) == null : StringUtils.isEmpty((String)exceptionWorkgroupName) ^ StringUtils.isEmpty(exceptionWorkgroupNamespace)) {
            throw new GroupNotFoundException("Could not locate exception workgroup with namespace '" + exceptionWorkgroupNamespace + "' and name '" + exceptionWorkgroupName + "'");
        }
        if (exceptionWorkgroup != null) {
            routeNode.setExceptionWorkgroupName(exceptionWorkgroup.getName());
            routeNode.setExceptionWorkgroupId(exceptionWorkgroup.getId());
        }
        if (((Boolean)this.getXPath().evaluate("./mandatoryRoute", node, XPathConstants.BOOLEAN)).booleanValue()) {
            routeNode.setMandatoryRouteInd(Boolean.valueOf((String)this.getXPath().evaluate("./mandatoryRoute", node, XPathConstants.STRING)));
        } else {
            routeNode.setMandatoryRouteInd(Boolean.FALSE);
        }
        if (((Boolean)this.getXPath().evaluate("./finalApproval", node, XPathConstants.BOOLEAN)).booleanValue()) {
            routeNode.setFinalApprovalInd(Boolean.valueOf((String)this.getXPath().evaluate("./finalApproval", node, XPathConstants.STRING)));
        } else {
            routeNode.setFinalApprovalInd(Boolean.FALSE);
        }
        NodeList children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node n = children.item(i);
            if (!(n instanceof Element)) continue;
            Element e = (Element)n;
            String name = e.getNodeName();
            String content = DocumentTypeXmlParser.getTextContent(e);
            routeNode.getConfigParams().add(new RouteNodeConfigParam(routeNode, name, content));
        }
        Map<String, String> cfgMap = Utilities.getKeyValueCollectionAsMap(routeNode.getConfigParams());
        if (!cfgMap.containsKey("ruleSelector")) {
            routeNode.getConfigParams().add(new RouteNodeConfigParam(routeNode, "ruleSelector", "Template"));
        }
        if (((Boolean)this.getXPath().evaluate("./ruleTemplate", node, XPathConstants.BOOLEAN)).booleanValue()) {
            String ruleTemplateName = (String)this.getXPath().evaluate("./ruleTemplate", node, XPathConstants.STRING);
            RuleTemplateBo ruleTemplate = KEWServiceLocator.getRuleTemplateService().findByRuleTemplateName(ruleTemplateName);
            if (ruleTemplate == null) {
                throw new XmlException("Rule template for node '" + routeNode.getRouteNodeName() + "' not found: " + ruleTemplateName);
            }
            routeNode.setRouteMethodName(ruleTemplateName);
            routeNode.setRouteMethodCode("FR");
        } else if (((Boolean)this.getXPath().evaluate("./routeModule", node, XPathConstants.BOOLEAN)).booleanValue()) {
            routeNode.setRouteMethodName((String)this.getXPath().evaluate("./routeModule", node, XPathConstants.STRING));
            routeNode.setRouteMethodCode("RM");
        } else if (((Boolean)this.getXPath().evaluate("./peopleFlows", node, XPathConstants.BOOLEAN)).booleanValue()) {
            routeNode.setRouteMethodCode("PF");
        } else if (((Boolean)this.getXPath().evaluate("./rulesEngine", node, XPathConstants.BOOLEAN)).booleanValue()) {
            Element rulesEngineElement = (Element)this.getXPath().evaluate("./rulesEngine", node, XPathConstants.NODE);
            String executorName = rulesEngineElement.getAttribute("executorName");
            String executorClass = rulesEngineElement.getAttribute("executorClass");
            if (StringUtils.isBlank((String)executorName) && StringUtils.isBlank((String)executorClass)) {
                throw new XmlException("The rulesEngine declaration must have at least one of 'executorName' or 'executorClass' attributes.");
            }
            if (StringUtils.isNotBlank((String)executorName) && StringUtils.isNotBlank((String)executorClass)) {
                throw new XmlException("Only one of 'executorName' or 'executorClass' may be declared on rulesEngine configuration, but both were declared.");
            }
            routeNode.setRouteMethodCode("RE");
        }
        String nodeType = null;
        if (((Boolean)this.getXPath().evaluate("./type", node, XPathConstants.BOOLEAN)).booleanValue()) {
            nodeType = (String)this.getXPath().evaluate("./type", node, XPathConstants.STRING);
        } else {
            localName = (String)this.getXPath().evaluate("local-name(.)", node, XPathConstants.STRING);
            if ("start".equalsIgnoreCase(localName)) {
                nodeType = "org.kuali.rice.kew.engine.node.InitialNode";
            } else if ("split".equalsIgnoreCase(localName)) {
                nodeType = "org.kuali.rice.kew.engine.node.SimpleSplitNode";
            } else if ("join".equalsIgnoreCase(localName)) {
                nodeType = "org.kuali.rice.kew.engine.node.SimpleJoinNode";
            } else if ("requests".equalsIgnoreCase(localName)) {
                nodeType = "org.kuali.rice.kew.engine.node.RequestsNode";
            } else if ("process".equalsIgnoreCase(localName)) {
                nodeType = "org.kuali.rice.kew.engine.node.SimpleSubProcessNode";
            } else if (NodeType.ROLE.getName().equalsIgnoreCase(localName)) {
                nodeType = RoleNode.class.getName();
            }
        }
        if (StringUtils.isEmpty((String)nodeType)) {
            throw new XmlException("Could not determine node type for the node named '" + routeNode.getRouteNodeName() + "'");
        }
        routeNode.setNodeType(nodeType);
        localName = (String)this.getXPath().evaluate("local-name(.)", node, XPathConstants.STRING);
        if ("split".equalsIgnoreCase(localName)) {
            context.splitNodeStack.addFirst(routeNode);
        } else if ("join".equalsIgnoreCase(localName) && context.splitNodeStack.size() != 0) {
            RouteNode splitNode = (RouteNode)context.splitNodeStack.removeFirst();
            context.branch = splitNode.getBranch();
        } else if (NodeType.ROLE.getName().equalsIgnoreCase(localName)) {
            routeNode.setRouteMethodName(RoleRouteModule.class.getName());
            routeNode.setRouteMethodCode("RM");
        }
        routeNode.setBranch(context.branch);
        return routeNode;
    }

    private static String getTextContent(Element element) {
        NodeList children = element.getChildNodes();
        if (children.getLength() == 0) {
            return "";
        }
        Node node = children.item(0);
        return node.getNodeValue();
    }

    private List getDocumentTypePolicies(NodeList documentTypePolicies, DocumentType documentType) throws XPathExpressionException, XmlException, ParserConfigurationException {
        ArrayList<DocumentTypePolicy> policies = new ArrayList<DocumentTypePolicy>();
        HashSet<String> policyNames = new HashSet<String>();
        for (int i = 0; i < documentTypePolicies.getLength(); ++i) {
            DocumentTypePolicy policy = new DocumentTypePolicy();
            try {
                String policyName = (String)this.getXPath().evaluate("./name", documentTypePolicies.item(i), XPathConstants.STRING);
                policy.setPolicyName(org.kuali.rice.kew.api.doctype.DocumentTypePolicy.fromCode((String)policyName).getCode().toUpperCase());
            }
            catch (XPathExpressionException xpee) {
                LOG.error("Error obtaining document type policy name", (Throwable)xpee);
                throw xpee;
            }
            try {
                if (((Boolean)this.getXPath().evaluate("./value", documentTypePolicies.item(i), XPathConstants.BOOLEAN)).booleanValue()) {
                    policy.setPolicyValue(Boolean.valueOf((String)this.getXPath().evaluate("./value", documentTypePolicies.item(i), XPathConstants.STRING)));
                } else {
                    policy.setPolicyValue(Boolean.FALSE);
                }
            }
            catch (XPathExpressionException xpee) {
                LOG.error("Error obtaining document type policy value", (Throwable)xpee);
                throw xpee;
            }
            try {
                String policyStringValue = (String)this.getXPath().evaluate("./stringValue", documentTypePolicies.item(i), XPathConstants.STRING);
                if (!StringUtils.isEmpty((String)policyStringValue)) {
                    policy.setPolicyStringValue(policyStringValue.toUpperCase());
                    policy.setPolicyValue(Boolean.TRUE);
                    if ("DOCUMENT_STATUS_POLICY".equalsIgnoreCase(org.kuali.rice.kew.api.doctype.DocumentTypePolicy.fromCode((String)policy.getPolicyName()).getCode())) {
                        boolean found = false;
                        for (int index = 0; index < KewApiConstants.DOCUMENT_STATUS_POLICY_VALUES.length; ++index) {
                            if (!KewApiConstants.DOCUMENT_STATUS_POLICY_VALUES[index].equalsIgnoreCase(policyStringValue)) continue;
                            found = true;
                            break;
                        }
                        if (!found) {
                            throw new XmlException("Application Document Status string value: " + policyStringValue + " is invalid.");
                        }
                    }
                } else {
                    if ("DOCUMENT_STATUS_POLICY".equalsIgnoreCase(org.kuali.rice.kew.api.doctype.DocumentTypePolicy.fromCode((String)policy.getPolicyName()).getCode())) {
                        throw new XmlException("Application Document Status Policy requires a <stringValue>");
                    }
                    String customConfig = DocumentTypeXmlParser.parseDocumentPolicyCustomXMLConfig(documentTypePolicies.item(i));
                    if (customConfig != null) {
                        policy.setPolicyStringValue(customConfig);
                    }
                }
            }
            catch (XPathExpressionException xpee) {
                LOG.error("Error obtaining document type policy string value", (Throwable)xpee);
                throw xpee;
            }
            if (!policyNames.add(policy.getPolicyName())) {
                throw new XmlException("Policy '" + policy.getPolicyName() + "' has already been defined on this document");
            }
            policies.add(policy);
            policy.setDocumentType(documentType);
        }
        return policies;
    }

    private static String parseDocumentPolicyCustomXMLConfig(Node policyNode) throws ParserConfigurationException {
        List<String> KNOWN_POLICY_ELEMENTS = Arrays.asList("name", "value", "stringValue");
        Document policyConfig = SafeXmlUtils.safeDocumentBuilderFactory().newDocumentBuilder().newDocument();
        Element root = policyConfig.createElement("config");
        policyConfig.appendChild(root);
        NodeList children = policyNode.getChildNodes();
        for (int j = 0; j < children.getLength(); ++j) {
            Node c = children.item(j);
            if (!(c instanceof Element) || KNOWN_POLICY_ELEMENTS.contains(c.getNodeName())) continue;
            root.appendChild(policyConfig.importNode(c, true));
        }
        return root.getChildNodes().getLength() > 0 ? XmlJotter.jotDocument((Document)policyConfig) : null;
    }

    private List getDocumentTypeAttributes(NodeList documentTypeAttributes, DocumentType documentType) throws XPathExpressionException, WorkflowException {
        ArrayList<DocumentTypeAttributeBo> attributes = new ArrayList<DocumentTypeAttributeBo>();
        for (int i = 0; i < documentTypeAttributes.getLength(); ++i) {
            String ruleAttributeName;
            DocumentTypeAttributeBo attribute = new DocumentTypeAttributeBo();
            attribute.setDocumentType(documentType);
            try {
                ruleAttributeName = (String)this.getXPath().evaluate("./name", documentTypeAttributes.item(i), XPathConstants.STRING);
            }
            catch (XPathExpressionException xpee) {
                LOG.error("Error obtaining rule attribute name", (Throwable)xpee);
                throw xpee;
            }
            RuleAttribute ruleAttribute = KEWServiceLocator.getRuleAttributeService().findByName(ruleAttributeName);
            if (ruleAttribute == null) {
                throw new WorkflowException("Could not find rule attribute: " + ruleAttributeName);
            }
            attribute.setDocumentType(documentType);
            attribute.setRuleAttribute(ruleAttribute);
            attribute.setOrderIndex(i + 1);
            attributes.add(attribute);
        }
        return attributes;
    }

    private RoutePathContext cloneContext(RoutePathContext context) {
        RoutePathContext localContext = new RoutePathContext();
        localContext.branch = context.branch;
        localContext.nodeQName = context.nodeQName;
        localContext.nodeXPath = context.nodeXPath;
        localContext.previousNodeQName = context.previousNodeQName;
        return localContext;
    }

    protected GroupService getGroupService() {
        return KimApiServiceLocator.getGroupService();
    }

    private class DocTypeNode {
        public final Node docNode;
        public final boolean isStandard;

        public DocTypeNode(Node newNode, boolean newFlag) {
            this.docNode = newNode;
            this.isStandard = newFlag;
        }
    }

    private class RoutePathContext {
        public BranchPrototype branch;
        public LinkedList splitNodeStack = new LinkedList();
        public String nodeXPath = ".";
        public String nodeQName = ":";
        public String previousNodeQName = "";

        private RoutePathContext() {
        }
    }

    private static class ApplicationDocumentStatusParser {
        private final Set<String> uniqueStatusNames = new HashSet<String>();
        private final List<ApplicationDocumentStatus> parsedStatuses = new ArrayList<ApplicationDocumentStatus>();
        private final List<ApplicationDocumentStatusCategory> parsedCategories = new ArrayList<ApplicationDocumentStatusCategory>();
        Counter newStatusSequence = new Counter();

        @Deprecated
        private ApplicationDocumentStatusParser() {
        }

        public static void parseValidApplicationStatuses(DocumentType documentType, Node documentTypeNode, XPath xpath) throws XPathExpressionException {
            ApplicationDocumentStatusParser parser = new ApplicationDocumentStatusParser();
            parser.parseValidApplicationStatusesHelper(documentType, documentTypeNode, xpath);
        }

        private void parseValidApplicationStatusesHelper(DocumentType documentType, Node documentTypeNode, XPath xpath) throws XPathExpressionException {
            NodeList appDocStatusList = (NodeList)xpath.evaluate("./validApplicationStatuses", documentTypeNode, XPathConstants.NODESET);
            if (appDocStatusList.getLength() > 1) {
                throw new XmlException("More than one validApplicationStatuses node is present in a document type node");
            }
            if (appDocStatusList.getLength() > 0) {
                this.parseCategoriesAndStatusesHelper(documentType, appDocStatusList);
            }
        }

        private void parseCategoriesAndStatusesHelper(DocumentType documentType, NodeList appDocStatusList) {
            NodeList appDocStatusChildren = appDocStatusList.item(0).getChildNodes();
            for (int appDocStatusChildrenIndex = 0; appDocStatusChildrenIndex < appDocStatusChildren.getLength(); ++appDocStatusChildrenIndex) {
                Node child = appDocStatusChildren.item(appDocStatusChildrenIndex);
                if ("status".equals(child.getNodeName())) {
                    ApplicationDocumentStatus status = this.parseApplicationDocumentStatusHelper(documentType, child);
                    this.parsedStatuses.add(status);
                    continue;
                }
                if (!"category".equals(child.getNodeName())) continue;
                Node categoryNameAttribute = child.getAttributes().getNamedItem("name");
                String categoryName = categoryNameAttribute.getNodeValue();
                this.validateUniqueName(categoryName);
                ApplicationDocumentStatusCategory category = new ApplicationDocumentStatusCategory();
                category.setDocumentType(documentType);
                category.setDocumentTypeId(documentType.getDocumentTypeId());
                category.setCategoryName(categoryName);
                NodeList categoryChildren = child.getChildNodes();
                for (int categoryChildIndex = 0; categoryChildIndex < categoryChildren.getLength(); ++categoryChildIndex) {
                    Node categoryChild = categoryChildren.item(categoryChildIndex);
                    if (1 != categoryChild.getNodeType()) continue;
                    ApplicationDocumentStatus status = this.parseApplicationDocumentStatusHelper(documentType, categoryChild);
                    status.setCategory(category);
                    this.parsedStatuses.add(status);
                }
                this.parsedCategories.add(category);
            }
            documentType.setValidApplicationStatuses(this.parsedStatuses);
            documentType.setApplicationStatusCategories(this.parsedCategories);
        }

        private ApplicationDocumentStatus parseApplicationDocumentStatusHelper(DocumentType documentType, Node node) {
            String statusName = node.getTextContent();
            this.validateUniqueName(statusName);
            ApplicationDocumentStatus status = new ApplicationDocumentStatus();
            status.setDocumentType(documentType);
            status.getApplicationDocumentStatusId().setDocumentTypeId(documentType.getDocumentTypeId());
            status.setStatusName(statusName);
            status.setSequenceNumber(this.newStatusSequence.nextValue());
            return status;
        }

        private void validateUniqueName(String name) throws XmlException {
            if (!this.uniqueStatusNames.add(name)) {
                throw new XmlException("duplicate application document status / category name in document type: " + name);
            }
        }
    }

    private static class Counter {
        private int value = 0;

        private Counter() {
        }

        public int nextValue() {
            return this.value++;
        }
    }
}

