/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kim.document;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.AttributeOverride;
import javax.persistence.AttributeOverrides;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.PrimaryKeyJoinColumn;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.sql.DataSource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.persistence.annotations.JoinFetch;
import org.eclipse.persistence.annotations.JoinFetchType;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;
import org.kuali.rice.coreservice.framework.CoreFrameworkServiceLocator;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.kew.framework.postprocessor.DocumentRouteStatusChange;
import org.kuali.rice.kim.api.identity.employment.EntityEmployment;
import org.kuali.rice.kim.api.role.Role;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.kim.api.type.KimType;
import org.kuali.rice.kim.bo.ui.KimDocumentRoleMember;
import org.kuali.rice.kim.bo.ui.KimDocumentRoleQualifier;
import org.kuali.rice.kim.bo.ui.KimDocumentRoleResponsibilityAction;
import org.kuali.rice.kim.bo.ui.PersonDocumentAddress;
import org.kuali.rice.kim.bo.ui.PersonDocumentAffiliation;
import org.kuali.rice.kim.bo.ui.PersonDocumentCitizenship;
import org.kuali.rice.kim.bo.ui.PersonDocumentEmail;
import org.kuali.rice.kim.bo.ui.PersonDocumentEmploymentInfo;
import org.kuali.rice.kim.bo.ui.PersonDocumentGroup;
import org.kuali.rice.kim.bo.ui.PersonDocumentName;
import org.kuali.rice.kim.bo.ui.PersonDocumentPhone;
import org.kuali.rice.kim.bo.ui.PersonDocumentPrivacy;
import org.kuali.rice.kim.bo.ui.PersonDocumentRole;
import org.kuali.rice.kim.bo.ui.RoleDocumentDelegationMember;
import org.kuali.rice.kim.bo.ui.RoleDocumentDelegationMemberQualifier;
import org.kuali.rice.kim.document.IdentityManagementKimDocument;
import org.kuali.rice.kim.impl.services.KimImplServiceLocator;
import org.kuali.rice.kim.impl.type.KimTypeAttributesHelper;
import org.kuali.rice.kim.service.KIMServiceLocatorInternal;
import org.kuali.rice.kim.service.UiDocumentService;
import org.kuali.rice.kns.service.DocumentHelperService;
import org.kuali.rice.kns.service.KNSServiceLocator;
import org.kuali.rice.krad.data.jpa.converters.BooleanYNConverter;
import org.kuali.rice.krad.data.jpa.converters.HashConverter;
import org.kuali.rice.krad.data.platform.MaxValueIncrementerFactory;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.util.GlobalVariables;
import org.springframework.jdbc.support.incrementer.DataFieldMaxValueIncrementer;

@AttributeOverrides(value={@AttributeOverride(name="documentNumber", column=@Column(name="FDOC_NBR"))})
@Entity
@Table(name="KRIM_PERSON_DOCUMENT_T")
public class IdentityManagementPersonDocument
extends IdentityManagementKimDocument
implements PersistenceWeaved,
PersistenceObject,
PersistenceWeavedFetchGroups {
    protected static final long serialVersionUID = -534993712085516925L;
    @Column(name="PRNCPL_ID")
    protected String principalId;
    @Column(name="PRNCPL_NM")
    protected String principalName;
    @Column(name="ENTITY_ID")
    protected String entityId;
    @Column(name="PRNCPL_PSWD")
    @Convert(converter=HashConverter.class)
    protected String password;
    @Column(name="UNIV_ID")
    protected String univId = "";
    @JoinFetch(value=JoinFetchType.OUTER)
    @OneToMany(targetEntity=PersonDocumentAffiliation.class, orphanRemoval=true, cascade={CascadeType.REFRESH, CascadeType.REMOVE, CascadeType.PERSIST})
    @JoinColumn(name="FDOC_NBR", referencedColumnName="FDOC_NBR", insertable=false, updatable=false)
    protected List<PersonDocumentAffiliation> affiliations = new ArrayList<PersonDocumentAffiliation>();
    @Transient
    protected String campusCode = "";
    @Transient
    protected Map<String, String> externalIdentifiers = null;
    @Column(name="ACTV_IND")
    @Convert(converter=BooleanYNConverter.class)
    protected boolean active = true;
    @Transient
    protected List<PersonDocumentCitizenship> citizenships = new ArrayList<PersonDocumentCitizenship>();
    @JoinFetch(value=JoinFetchType.OUTER)
    @OneToMany(targetEntity=PersonDocumentName.class, orphanRemoval=true, cascade={CascadeType.REFRESH, CascadeType.REMOVE, CascadeType.PERSIST})
    @JoinColumn(name="FDOC_NBR", referencedColumnName="FDOC_NBR", insertable=false, updatable=false)
    protected List<PersonDocumentName> names = new ArrayList<PersonDocumentName>();
    @JoinFetch(value=JoinFetchType.OUTER)
    @OneToMany(targetEntity=PersonDocumentAddress.class, orphanRemoval=true, cascade={CascadeType.REFRESH, CascadeType.REMOVE, CascadeType.PERSIST})
    @JoinColumn(name="FDOC_NBR", referencedColumnName="FDOC_NBR", insertable=false, updatable=false)
    protected List<PersonDocumentAddress> addrs = new ArrayList<PersonDocumentAddress>();
    @JoinFetch(value=JoinFetchType.OUTER)
    @OneToMany(targetEntity=PersonDocumentPhone.class, orphanRemoval=true, cascade={CascadeType.REFRESH, CascadeType.REMOVE, CascadeType.PERSIST})
    @JoinColumn(name="FDOC_NBR", referencedColumnName="FDOC_NBR", insertable=false, updatable=false)
    protected List<PersonDocumentPhone> phones = new ArrayList<PersonDocumentPhone>();
    @JoinFetch(value=JoinFetchType.OUTER)
    @OneToMany(targetEntity=PersonDocumentEmail.class, orphanRemoval=true, cascade={CascadeType.REFRESH, CascadeType.REMOVE, CascadeType.PERSIST})
    @JoinColumn(name="FDOC_NBR", referencedColumnName="FDOC_NBR", insertable=false, updatable=false)
    protected List<PersonDocumentEmail> emails = new ArrayList<PersonDocumentEmail>();
    @JoinFetch(value=JoinFetchType.OUTER)
    @OneToMany(targetEntity=PersonDocumentGroup.class, orphanRemoval=true, cascade={CascadeType.REFRESH, CascadeType.REMOVE, CascadeType.PERSIST})
    @JoinColumn(name="FDOC_NBR", referencedColumnName="FDOC_NBR", insertable=false, updatable=false)
    protected List<PersonDocumentGroup> groups = new ArrayList<PersonDocumentGroup>();
    @JoinFetch(value=JoinFetchType.OUTER)
    @OneToMany(targetEntity=PersonDocumentRole.class, orphanRemoval=true, cascade={CascadeType.REFRESH, CascadeType.REMOVE, CascadeType.PERSIST})
    @JoinColumn(name="FDOC_NBR", referencedColumnName="FDOC_NBR", insertable=false, updatable=false)
    protected List<PersonDocumentRole> roles = new ArrayList<PersonDocumentRole>();
    @JoinFetch(value=JoinFetchType.OUTER)
    @OneToOne(targetEntity=PersonDocumentPrivacy.class, orphanRemoval=true, cascade={CascadeType.REFRESH, CascadeType.REMOVE, CascadeType.PERSIST})
    @PrimaryKeyJoinColumn(name="FDOC_NBR", referencedColumnName="FDOC_NBR")
    protected PersonDocumentPrivacy privacy = new PersonDocumentPrivacy();
    @Transient
    protected Boolean autoGeneratePrincipalId;
    @Transient
    protected boolean newDocument = false;
    @Transient
    protected transient DocumentHelperService documentHelperService;
    @Transient
    protected transient UiDocumentService uiDocumentService;

    public String getPrincipalId() {
        return this._persistence_get_principalId();
    }

    public void setPrincipalId(String principalId) {
        this._persistence_set_principalId(principalId);
    }

    public String getPrincipalName() {
        return this._persistence_get_principalName();
    }

    public void setPrincipalName(String principalName) {
        this._persistence_set_principalName(principalName);
    }

    public String getEntityId() {
        return this._persistence_get_entityId();
    }

    public void setEntityId(String entityId) {
        this._persistence_set_entityId(entityId);
    }

    public List<PersonDocumentAffiliation> getAffiliations() {
        return this._persistence_get_affiliations();
    }

    public void setAffiliations(List<PersonDocumentAffiliation> affiliations) {
        this._persistence_set_affiliations(affiliations);
    }

    public String getCampusCode() {
        return this.campusCode;
    }

    public void setCampusCode(String campusCode) {
        this.campusCode = campusCode;
    }

    public Map<String, String> getExternalIdentifiers() {
        return this.externalIdentifiers;
    }

    public void setExternalIdentifiers(Map<String, String> externalIdentifiers) {
        this.externalIdentifiers = externalIdentifiers;
    }

    public String getPassword() {
        return this._persistence_get_password();
    }

    public void setPassword(String password) {
        this._persistence_set_password(password);
    }

    public boolean isActive() {
        return this._persistence_get_active();
    }

    public void setActive(boolean active) {
        this._persistence_set_active(active);
    }

    public List<PersonDocumentCitizenship> getCitizenships() {
        return this.citizenships;
    }

    public void setCitizenships(List<PersonDocumentCitizenship> citizenships) {
        this.citizenships = citizenships;
    }

    public List<PersonDocumentName> getNames() {
        return this._persistence_get_names();
    }

    public void setNames(List<PersonDocumentName> names) {
        this._persistence_set_names(names);
    }

    public List<PersonDocumentAddress> getAddrs() {
        return this._persistence_get_addrs();
    }

    public void setAddrs(List<PersonDocumentAddress> addrs) {
        this._persistence_set_addrs(addrs);
    }

    public List<PersonDocumentPhone> getPhones() {
        return this._persistence_get_phones();
    }

    public void setPhones(List<PersonDocumentPhone> phones) {
        this._persistence_set_phones(phones);
    }

    public List<PersonDocumentEmail> getEmails() {
        return this._persistence_get_emails();
    }

    public void setEmails(List<PersonDocumentEmail> emails) {
        this._persistence_set_emails(emails);
    }

    public void setGroups(List<PersonDocumentGroup> groups) {
        this._persistence_set_groups(groups);
    }

    public List<PersonDocumentRole> getRoles() {
        return this._persistence_get_roles();
    }

    public void setRoles(List<PersonDocumentRole> roles) {
        this._persistence_set_roles(roles);
    }

    public List<PersonDocumentGroup> getGroups() {
        return this._persistence_get_groups();
    }

    public String getUnivId() {
        return this._persistence_get_univId();
    }

    public void setUnivId(String univId) {
        this._persistence_set_univId(univId);
    }

    public PersonDocumentPrivacy getPrivacy() {
        return this._persistence_get_privacy();
    }

    public void setPrivacy(PersonDocumentPrivacy privacy) {
        this._persistence_set_privacy(privacy);
    }

    public void initializeDocumentForNewPerson() {
        DataFieldMaxValueIncrementer incrementer;
        if (this.isPrincipalIdAutoGenerated() && StringUtils.isBlank((String)this._persistence_get_principalId())) {
            incrementer = MaxValueIncrementerFactory.getIncrementer((DataSource)KimImplServiceLocator.getDataSource(), (String)"KRIM_PRNCPL_ID_S");
            this._persistence_set_principalId(incrementer.nextStringValue());
        }
        if (StringUtils.isBlank((String)this._persistence_get_entityId())) {
            incrementer = MaxValueIncrementerFactory.getIncrementer((DataSource)KimImplServiceLocator.getDataSource(), (String)"KRIM_ENTITY_ID_S");
            this._persistence_set_entityId(incrementer.nextStringValue());
        }
        this.newDocument = true;
    }

    public boolean isPrincipalIdAutoGenerated() {
        if (this.autoGeneratePrincipalId == null) {
            this.autoGeneratePrincipalId = this.getParameterService().getParameterValueAsBoolean("KR-IDM", "Document", "AUTO_GENERATE_PRINCIPAL_ID", Boolean.TRUE);
        }
        return this.autoGeneratePrincipalId;
    }

    public boolean isNewDocument() {
        return this.newDocument;
    }

    public ParameterService getParameterService() {
        return CoreFrameworkServiceLocator.getParameterService();
    }

    public List buildListOfDeletionAwareLists() {
        List managedLists = super.buildListOfDeletionAwareLists();
        ArrayList<PersonDocumentEmploymentInfo> empInfos = new ArrayList<PersonDocumentEmploymentInfo>();
        for (PersonDocumentAffiliation affiliation : this.getAffiliations()) {
            empInfos.addAll(affiliation.getEmpInfos());
        }
        managedLists.add(empInfos);
        managedLists.add(this.getAffiliations());
        managedLists.add(this.getCitizenships());
        managedLists.add(this.getPhones());
        managedLists.add(this.getAddrs());
        managedLists.add(this.getEmails());
        managedLists.add(this.getNames());
        managedLists.add(this.getGroups());
        managedLists.add(this.getRoles());
        return managedLists;
    }

    public void doRouteStatusChange(DocumentRouteStatusChange statusChangeEvent) {
        super.doRouteStatusChange(statusChangeEvent);
        if (this.getDocumentHeader().getWorkflowDocument().isProcessed()) {
            this.setIfRolesEditable();
            KIMServiceLocatorInternal.getUiDocumentService().saveEntityPerson(this);
        }
    }

    public void prepareForSave() {
        DataFieldMaxValueIncrementer incrementer;
        if (StringUtils.isBlank((String)this.getPrivacy().getDocumentNumber())) {
            this.getPrivacy().setDocumentNumber(this.getDocumentNumber());
        }
        this.setEmployeeRecordIds();
        for (PersonDocumentRole personDocumentRole : this.getRoles()) {
            personDocumentRole.setDocumentNumber(this.getDocumentNumber());
            for (KimDocumentRoleMember rolePrncpl : personDocumentRole.getRolePrncpls()) {
                rolePrncpl.setDocumentNumber(this.getDocumentNumber());
                rolePrncpl.setRoleId(personDocumentRole.getRoleId());
                if (StringUtils.isEmpty((String)rolePrncpl.getRoleMemberId())) {
                    DataFieldMaxValueIncrementer incrementer2 = MaxValueIncrementerFactory.getIncrementer((DataSource)KimImplServiceLocator.getDataSource(), (String)"KRIM_ROLE_MBR_ID_S");
                    rolePrncpl.setRoleMemberId(incrementer2.nextStringValue());
                }
                for (KimDocumentRoleQualifier qualifier : rolePrncpl.getQualifiers()) {
                    qualifier.setDocumentNumber(this.getDocumentNumber());
                    qualifier.setRoleMemberId(rolePrncpl.getRoleMemberId());
                    qualifier.setKimTypId(personDocumentRole.getKimTypeId());
                }
                for (KimDocumentRoleResponsibilityAction responsibilityAction : rolePrncpl.getRoleRspActions()) {
                    responsibilityAction.setDocumentNumber(this.getDocumentNumber());
                    responsibilityAction.setRoleMemberId(rolePrncpl.getRoleMemberId());
                    responsibilityAction.setRoleResponsibilityId("*");
                }
            }
        }
        if (this.getDelegationMembers() != null) {
            for (RoleDocumentDelegationMember roleDocumentDelegationMember : this.getDelegationMembers()) {
                roleDocumentDelegationMember.setDocumentNumber(this.getDocumentNumber());
                for (RoleDocumentDelegationMemberQualifier qualifier : roleDocumentDelegationMember.getQualifiers()) {
                    qualifier.setDocumentNumber(this.getDocumentNumber());
                    qualifier.setKimTypId(roleDocumentDelegationMember.getRoleBo().getKimTypeId());
                }
                this.addDelegationMemberToDelegation(roleDocumentDelegationMember);
            }
        }
        if (this.getAddrs() != null) {
            for (PersonDocumentAddress personDocumentAddress : this.getAddrs()) {
                personDocumentAddress.setDocumentNumber(this.getDocumentNumber());
                if (!StringUtils.isEmpty((String)personDocumentAddress.getEntityAddressId())) continue;
                incrementer = MaxValueIncrementerFactory.getIncrementer((DataSource)KimImplServiceLocator.getDataSource(), (String)"KRIM_ENTITY_ADDR_ID_S");
                personDocumentAddress.setEntityAddressId(incrementer.nextStringValue());
            }
        }
        if (this.getAffiliations() != null) {
            String nextValue = null;
            for (PersonDocumentAffiliation affiliation : this.getAffiliations()) {
                affiliation.setDocumentNumber(this.getDocumentNumber());
                if (StringUtils.isEmpty((String)affiliation.getEntityAffiliationId())) {
                    DataFieldMaxValueIncrementer incrementer3 = MaxValueIncrementerFactory.getIncrementer((DataSource)KimImplServiceLocator.getDataSource(), (String)"KRIM_ENTITY_AFLTN_ID_S");
                    nextValue = incrementer3.nextStringValue();
                    affiliation.setEntityAffiliationId(nextValue);
                }
                for (PersonDocumentEmploymentInfo empInfo : affiliation.getEmpInfos()) {
                    empInfo.setDocumentNumber(this.getDocumentNumber());
                    if (!StringUtils.isEmpty((String)empInfo.getEntityAffiliationId())) continue;
                    empInfo.setEntityAffiliationId(affiliation.getEntityAffiliationId());
                }
            }
        }
        if (this.getEmails() != null) {
            for (PersonDocumentEmail personDocumentEmail : this.getEmails()) {
                personDocumentEmail.setDocumentNumber(this.getDocumentNumber());
                if (!StringUtils.isEmpty((String)personDocumentEmail.getEntityEmailId())) continue;
                incrementer = MaxValueIncrementerFactory.getIncrementer((DataSource)KimImplServiceLocator.getDataSource(), (String)"KRIM_ENTITY_EMAIL_ID_S");
                personDocumentEmail.setEntityEmailId(incrementer.nextStringValue());
            }
        }
        if (this.getGroups() != null) {
            for (PersonDocumentGroup personDocumentGroup : this.getGroups()) {
                personDocumentGroup.setDocumentNumber(this.getDocumentNumber());
                if (!StringUtils.isEmpty((String)personDocumentGroup.getGroupMemberId())) continue;
                incrementer = MaxValueIncrementerFactory.getIncrementer((DataSource)KimImplServiceLocator.getDataSource(), (String)"KRIM_GRP_MBR_ID_S");
                personDocumentGroup.setGroupMemberId(incrementer.nextStringValue());
            }
        }
        if (this.getNames() != null) {
            for (PersonDocumentName personDocumentName : this.getNames()) {
                personDocumentName.setDocumentNumber(this.getDocumentNumber());
                if (!StringUtils.isEmpty((String)personDocumentName.getEntityNameId())) continue;
                incrementer = MaxValueIncrementerFactory.getIncrementer((DataSource)KimImplServiceLocator.getDataSource(), (String)"KRIM_ENTITY_NM_ID_S");
                personDocumentName.setEntityNameId(incrementer.nextStringValue());
            }
        }
        if (this.getPhones() != null) {
            for (PersonDocumentPhone personDocumentPhone : this.getPhones()) {
                personDocumentPhone.setDocumentNumber(this.getDocumentNumber());
                if (!StringUtils.isEmpty((String)personDocumentPhone.getEntityPhoneId())) continue;
                incrementer = MaxValueIncrementerFactory.getIncrementer((DataSource)KimImplServiceLocator.getDataSource(), (String)"KRIM_ENTITY_PHONE_ID_S");
                personDocumentPhone.setEntityPhoneId(incrementer.nextStringValue());
            }
        }
    }

    protected void setEmployeeRecordIds() {
        List<EntityEmployment> empInfos = this.getUiDocumentService().getEntityEmploymentInformationInfo(this.getEntityId());
        for (PersonDocumentAffiliation affiliation : this.getAffiliations()) {
            int employeeRecordCounter = CollectionUtils.isEmpty(empInfos) ? 0 : empInfos.size();
            for (PersonDocumentEmploymentInfo empInfo : affiliation.getEmpInfos()) {
                if (CollectionUtils.isNotEmpty(empInfos)) {
                    for (EntityEmployment origEmpInfo : empInfos) {
                        if (!origEmpInfo.getId().equals(empInfo.getEntityEmploymentId())) continue;
                        empInfo.setEmploymentRecordId(origEmpInfo.getEmploymentRecordId());
                    }
                }
                if (!StringUtils.isEmpty((String)empInfo.getEmploymentRecordId())) continue;
                empInfo.setEmploymentRecordId("" + ++employeeRecordCounter);
            }
        }
    }

    public KimTypeAttributesHelper getKimTypeAttributesHelper(String roleId) {
        Role role = KimApiServiceLocator.getRoleService().getRole(roleId);
        KimType kimTypeInfo = KimApiServiceLocator.getKimTypeInfoService().getKimType(role.getKimTypeId());
        return new KimTypeAttributesHelper(kimTypeInfo);
    }

    public void setIfRolesEditable() {
        if (CollectionUtils.isNotEmpty(this.getRoles())) {
            for (PersonDocumentRole role : this.getRoles()) {
                role.setEditable(this.validAssignRole(role));
            }
        }
    }

    public boolean validAssignRole(PersonDocumentRole role) {
        boolean rulePassed = true;
        if (StringUtils.isNotEmpty((String)role.getNamespaceCode())) {
            HashMap<String, String> additionalPermissionDetails = new HashMap<String, String>();
            additionalPermissionDetails.put("namespaceCode", role.getNamespaceCode());
            additionalPermissionDetails.put("roleName", role.getRoleName());
            if (!this.getDocumentHelperService().getDocumentAuthorizer((Document)this).isAuthorizedByTemplate((Object)this, "KR-IDM", "Assign Role", GlobalVariables.getUserSession().getPrincipalId(), additionalPermissionDetails, null)) {
                rulePassed = false;
            }
        }
        return rulePassed;
    }

    protected DocumentHelperService getDocumentHelperService() {
        if (this.documentHelperService == null) {
            this.documentHelperService = KNSServiceLocator.getDocumentHelperService();
        }
        return this.documentHelperService;
    }

    protected UiDocumentService getUiDocumentService() {
        if (this.uiDocumentService == null) {
            this.uiDocumentService = KIMServiceLocatorInternal.getUiDocumentService();
        }
        return this.uiDocumentService;
    }

    @Override
    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    @Override
    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new IdentityManagementPersonDocument();
    }

    @Override
    public Object _persistence_get(String string) {
        if (string == "univId") {
            return this.univId;
        }
        if (string == "addrs") {
            return this.addrs;
        }
        if (string == "roles") {
            return this.roles;
        }
        if (string == "active") {
            return this.active;
        }
        if (string == "affiliations") {
            return this.affiliations;
        }
        if (string == "phones") {
            return this.phones;
        }
        if (string == "groups") {
            return this.groups;
        }
        if (string == "privacy") {
            return this.privacy;
        }
        if (string == "principalId") {
            return this.principalId;
        }
        if (string == "principalName") {
            return this.principalName;
        }
        if (string == "entityId") {
            return this.entityId;
        }
        if (string == "emails") {
            return this.emails;
        }
        if (string == "password") {
            return this.password;
        }
        if (string == "names") {
            return this.names;
        }
        return super._persistence_get(string);
    }

    @Override
    public void _persistence_set(String string, Object object) {
        if (string == "univId") {
            this.univId = (String)object;
            return;
        }
        if (string == "addrs") {
            this.addrs = (List)object;
            return;
        }
        if (string == "roles") {
            this.roles = (List)object;
            return;
        }
        if (string == "active") {
            this.active = (Boolean)object;
            return;
        }
        if (string == "affiliations") {
            this.affiliations = (List)object;
            return;
        }
        if (string == "phones") {
            this.phones = (List)object;
            return;
        }
        if (string == "groups") {
            this.groups = (List)object;
            return;
        }
        if (string == "privacy") {
            this.privacy = (PersonDocumentPrivacy)((Object)object);
            return;
        }
        if (string == "principalId") {
            this.principalId = (String)object;
            return;
        }
        if (string == "principalName") {
            this.principalName = (String)object;
            return;
        }
        if (string == "entityId") {
            this.entityId = (String)object;
            return;
        }
        if (string == "emails") {
            this.emails = (List)object;
            return;
        }
        if (string == "password") {
            this.password = (String)object;
            return;
        }
        if (string == "names") {
            this.names = (List)object;
            return;
        }
        super._persistence_set(string, object);
    }

    public String _persistence_get_univId() {
        this._persistence_checkFetched("univId");
        return this.univId;
    }

    public void _persistence_set_univId(String string) {
        this._persistence_checkFetchedForSet("univId");
        this.univId = string;
    }

    public List _persistence_get_addrs() {
        this._persistence_checkFetched("addrs");
        return this.addrs;
    }

    public void _persistence_set_addrs(List list) {
        this._persistence_checkFetchedForSet("addrs");
        this.addrs = list;
    }

    public List _persistence_get_roles() {
        this._persistence_checkFetched("roles");
        return this.roles;
    }

    public void _persistence_set_roles(List list) {
        this._persistence_checkFetchedForSet("roles");
        this.roles = list;
    }

    public boolean _persistence_get_active() {
        this._persistence_checkFetched("active");
        return this.active;
    }

    public void _persistence_set_active(boolean bl) {
        this._persistence_checkFetchedForSet("active");
        this.active = bl;
    }

    public List _persistence_get_affiliations() {
        this._persistence_checkFetched("affiliations");
        return this.affiliations;
    }

    public void _persistence_set_affiliations(List list) {
        this._persistence_checkFetchedForSet("affiliations");
        this.affiliations = list;
    }

    public List _persistence_get_phones() {
        this._persistence_checkFetched("phones");
        return this.phones;
    }

    public void _persistence_set_phones(List list) {
        this._persistence_checkFetchedForSet("phones");
        this.phones = list;
    }

    public List _persistence_get_groups() {
        this._persistence_checkFetched("groups");
        return this.groups;
    }

    public void _persistence_set_groups(List list) {
        this._persistence_checkFetchedForSet("groups");
        this.groups = list;
    }

    public PersonDocumentPrivacy _persistence_get_privacy() {
        this._persistence_checkFetched("privacy");
        return this.privacy;
    }

    public void _persistence_set_privacy(PersonDocumentPrivacy personDocumentPrivacy) {
        this._persistence_checkFetchedForSet("privacy");
        this.privacy = personDocumentPrivacy;
    }

    public String _persistence_get_principalId() {
        this._persistence_checkFetched("principalId");
        return this.principalId;
    }

    public void _persistence_set_principalId(String string) {
        this._persistence_checkFetchedForSet("principalId");
        this.principalId = string;
    }

    public String _persistence_get_principalName() {
        this._persistence_checkFetched("principalName");
        return this.principalName;
    }

    public void _persistence_set_principalName(String string) {
        this._persistence_checkFetchedForSet("principalName");
        this.principalName = string;
    }

    public String _persistence_get_entityId() {
        this._persistence_checkFetched("entityId");
        return this.entityId;
    }

    public void _persistence_set_entityId(String string) {
        this._persistence_checkFetchedForSet("entityId");
        this.entityId = string;
    }

    public List _persistence_get_emails() {
        this._persistence_checkFetched("emails");
        return this.emails;
    }

    public void _persistence_set_emails(List list) {
        this._persistence_checkFetchedForSet("emails");
        this.emails = list;
    }

    public String _persistence_get_password() {
        this._persistence_checkFetched("password");
        return this.password;
    }

    public void _persistence_set_password(String string) {
        this._persistence_checkFetchedForSet("password");
        this.password = string;
    }

    public List _persistence_get_names() {
        this._persistence_checkFetched("names");
        return this.names;
    }

    public void _persistence_set_names(List list) {
        this._persistence_checkFetchedForSet("names");
        this.names = list;
    }
}

