/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kns.workflow.attribute;

import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.rice.core.api.util.KeyValue;
import org.kuali.rice.core.api.util.xml.SafeXmlUtils;
import org.kuali.rice.core.api.util.xml.XmlJotter;
import org.kuali.rice.kew.rule.xmlrouting.XPathHelper;
import org.kuali.rice.krad.keyvalues.KeyValuesFinder;
import org.kuali.rice.krad.service.DataDictionaryService;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Deprecated
public class KualiXmlAttributeHelper {
    private static Logger LOG = LogManager.getLogger(KualiXmlAttributeHelper.class);
    private static XPath xpath = XPathHelper.newXPath();
    private static final String testVal = "'/[^']*'";
    private static final String testVal2 = "/[^/]+/*";
    private static final String cleanVal = "[^/']+";
    private static final String ruledataVal = "ruledata[^']*'([^']*)";
    private static final Pattern xPathPattern = Pattern.compile("'/[^']*'");
    private static final Pattern termPattern = Pattern.compile("/[^/]+/*");
    private static final Pattern cleanPattern = Pattern.compile("[^/']+");
    private static final Pattern targetPattern = Pattern.compile("ruledata[^']*'([^']*)");
    public static final String ATTRIBUTE_LABEL_BO_REFERENCE_PREFIX = "kuali_dd_label(";
    public static final String ATTRIBUTE_LABEL_BO_REFERENCE_SUFFIX = ")";
    public static final String ATTRIBUTE_SHORT_LABEL_BO_REFERENCE_PREFIX = "kuali_dd_short_label(";
    public static final String ATTRIBUTE_SHORT_LABEL_BO_REFERENCE_SUFFIX = ")";
    private static final String KUALI_VALUES_FINDER_REFERENCE_PREFIX = "kuali_values_finder_class(";
    private static final String KUALI_VALUES_FINDER_REFERENCE_SUFFIX = ")";
    public static final String notFound = "Label Not Found";
    private String lastXPath = "";

    public Element processConfigXML(Element root) {
        return this.processConfigXML(root, null);
    }

    /*
     * WARNING - void declaration
     */
    public Element processConfigXML(Element root, String[] xpathExpressionElements) {
        NodeList fields = root.getElementsByTagName("fieldDef");
        Element theTag = null;
        String docContent = "";
        Document xmlDoc = null;
        if (!this.xmlDocumentContentExists(root)) {
            fields = root.getElementsByTagName("fieldDef");
            xmlDoc = root.getOwnerDocument();
        }
        for (int i = 0; i < fields.getLength(); ++i) {
            NodeList fieldEvaluationElements;
            NodeList displayTagElements;
            List<String> xPathTerms;
            Object name = null;
            if (!this.xmlDocumentContentExists(root) && (xPathTerms = this.getXPathTerms(theTag = (Element)fields.item(i))).size() != 0) {
                Node iterNode = xmlDoc.createElement("xmlDocumentContent");
                xmlDoc.normalize();
                iterNode.normalize();
                for (int j = 0; j < xPathTerms.size(); ++j) {
                    iterNode.appendChild(xmlDoc.createElement(xPathTerms.get(j)));
                    xmlDoc.normalize();
                    iterNode = iterNode.getFirstChild();
                    iterNode.normalize();
                }
                iterNode.setTextContent("%" + xPathTerms.get(xPathTerms.size() - 1) + "%");
                root.appendChild(iterNode);
            }
            if ((displayTagElements = (theTag = (Element)fields.item(i)).getElementsByTagName("display")).getLength() == 1) {
                Element displayTag = (Element)displayTagElements.item(0);
                ArrayList<Node> valuesElementsToAdd = new ArrayList<Node>();
                for (int w = 0; w < displayTag.getChildNodes().getLength(); ++w) {
                    Node node = displayTag.getChildNodes().item(w);
                    if (node == null || !"values".equals(node.getNodeName()) || node.getChildNodes().getLength() <= 0) continue;
                    String valuesNodeText = node.getFirstChild().getNodeValue();
                    String potentialClassName = KualiXmlAttributeHelper.getPotentialKualiClassName(valuesNodeText, KUALI_VALUES_FINDER_REFERENCE_PREFIX, ")");
                    if (StringUtils.isNotBlank((String)potentialClassName)) {
                        String errorMessage;
                        try {
                            Class<?> finderClass = Class.forName(potentialClassName);
                            KeyValuesFinder finder = (KeyValuesFinder)finderClass.newInstance();
                            NamedNodeMap valuesNodeAttributes = node.getAttributes();
                            Node potentialSelectedAttribute = valuesNodeAttributes != null ? valuesNodeAttributes.getNamedItem("selected") : null;
                            for (KeyValue keyValue : finder.getKeyValues()) {
                                Element newValuesElement = root.getOwnerDocument().createElement("values");
                                newValuesElement.appendChild(root.getOwnerDocument().createTextNode(keyValue.getKey()));
                                newValuesElement.setAttribute("title", keyValue.getValue());
                                if (potentialSelectedAttribute != null) {
                                    newValuesElement.setAttribute("selected", potentialSelectedAttribute.getNodeValue());
                                }
                                valuesElementsToAdd.add(newValuesElement);
                            }
                        }
                        catch (ClassNotFoundException cnfe) {
                            errorMessage = "Caught an exception trying to find class '" + potentialClassName + "'";
                            LOG.error(errorMessage, (Throwable)cnfe);
                            throw new RuntimeException(errorMessage, cnfe);
                        }
                        catch (InstantiationException ie) {
                            errorMessage = "Caught an exception trying to instantiate class '" + potentialClassName + "'";
                            LOG.error(errorMessage, (Throwable)ie);
                            throw new RuntimeException(errorMessage, ie);
                        }
                        catch (IllegalAccessException iae) {
                            errorMessage = "Caught an access exception trying to instantiate class '" + potentialClassName + "'";
                            LOG.error(errorMessage, (Throwable)iae);
                            throw new RuntimeException(errorMessage, iae);
                        }
                    } else {
                        valuesElementsToAdd.add(node.cloneNode(true));
                    }
                    displayTag.removeChild(node);
                }
                for (Element element : valuesElementsToAdd) {
                    displayTag.appendChild(element);
                }
            }
            if (xpathExpressionElements != null && xpathExpressionElements.length > 0 && (fieldEvaluationElements = theTag.getElementsByTagName("fieldEvaluation")).getLength() == 1) {
                void var13_22;
                Element fieldEvaluationTag = (Element)fieldEvaluationElements.item(0);
                ArrayList<Element> tagsToAdd = new ArrayList<Element>();
                boolean bl = false;
                while (var13_22 < fieldEvaluationTag.getChildNodes().getLength()) {
                    Node fieldEvaluationChildNode = fieldEvaluationTag.getChildNodes().item((int)var13_22);
                    Element newTagToAdd = null;
                    if (fieldEvaluationChildNode != null && "xpathexpression".equals(fieldEvaluationChildNode.getNodeName())) {
                        newTagToAdd = root.getOwnerDocument().createElement("xpathexpression");
                        newTagToAdd.appendChild(root.getOwnerDocument().createTextNode(this.generateNewXpathExpression(fieldEvaluationChildNode.getFirstChild().getNodeValue(), xpathExpressionElements)));
                        tagsToAdd.add(newTagToAdd);
                        fieldEvaluationTag.removeChild(fieldEvaluationChildNode);
                    }
                    ++var13_22;
                }
                for (Element elementToAdd : tagsToAdd) {
                    fieldEvaluationTag.appendChild(elementToAdd);
                }
            }
            theTag.setAttribute("title", this.getBusinessObjectTitle(theTag));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(XmlJotter.jotNode((Node)root));
            StringWriter xmlBuffer = new StringWriter();
            try {
                root.normalize();
                DOMSource source = new DOMSource(root);
                StreamResult result = new StreamResult(xmlBuffer);
                SafeXmlUtils.safeTransformerFactory().newTransformer().transform(source, result);
            }
            catch (Exception e) {
                LOG.debug(" Exception when printing debug XML output " + e);
            }
            LOG.debug((CharSequence)xmlBuffer.getBuffer());
        }
        return root;
    }

    private String generateNewXpathExpression(String currentXpathExpression, String[] newXpathExpressionElements) {
        StringBuffer returnableString = new StringBuffer();
        for (int i = 0; i < newXpathExpressionElements.length; ++i) {
            String newXpathElement = newXpathExpressionElements[i];
            returnableString.append(newXpathElement);
            if (i + 1 == newXpathExpressionElements.length && newXpathExpressionElements.length != 1) continue;
            returnableString.append(currentXpathExpression);
        }
        return returnableString.toString();
    }

    private String getXPathText(Element root) {
        try {
            String textContent = null;
            Node node = (Node)xpath.evaluate(".//xpathexpression", root, XPathConstants.NODE);
            if (node != null) {
                textContent = node.getTextContent();
            }
            return textContent;
        }
        catch (XPathExpressionException e) {
            LOG.error("No XPath expression text found in element xpathexpression of configXML for document. " + e);
            return null;
        }
    }

    private boolean xmlDocumentContentExists(Element root) {
        try {
            if (((NodeList)xpath.evaluate("//xmlDocumentContent", root, XPathConstants.NODESET)).getLength() == 0) {
                return false;
            }
        }
        catch (XPathExpressionException e) {
            LOG.error("Error parsing xmlDocumentConfig.  " + e);
            return false;
        }
        return true;
    }

    public static String getPotentialKualiClassName(String testString, String prefixIndicator, String suffixIndicator) {
        if (StringUtils.isNotBlank((String)testString) && testString.startsWith(prefixIndicator) && testString.endsWith(suffixIndicator)) {
            return testString.substring(prefixIndicator.length(), testString.lastIndexOf(suffixIndicator));
        }
        return null;
    }

    private String getBusinessObjectTitle(Element root) {
        String businessObjectName = null;
        String businessObjectText = root.getAttribute("title");
        String potentialClassNameLongLabel = KualiXmlAttributeHelper.getPotentialKualiClassName(businessObjectText, ATTRIBUTE_LABEL_BO_REFERENCE_PREFIX, ")");
        String potentialClassNameShortLabel = KualiXmlAttributeHelper.getPotentialKualiClassName(businessObjectText, ATTRIBUTE_SHORT_LABEL_BO_REFERENCE_PREFIX, ")");
        boolean requestedShortLabel = false;
        if (StringUtils.isNotBlank((String)potentialClassNameLongLabel)) {
            businessObjectName = potentialClassNameLongLabel;
        } else if (StringUtils.isNotBlank((String)potentialClassNameShortLabel)) {
            businessObjectName = potentialClassNameShortLabel;
            requestedShortLabel = true;
        }
        if (StringUtils.isNotBlank((String)businessObjectName)) {
            DataDictionaryService DDService = KRADServiceLocatorWeb.getDataDictionaryService();
            String title = null;
            String targetVal = this.lastXPath;
            if (LOG.isErrorEnabled()) {
                LOG.debug("Finding title in BO=" + businessObjectName + " ObjectName=" + targetVal);
            }
            if (StringUtils.isNotBlank((String)targetVal) && StringUtils.isNotBlank((String)(title = requestedShortLabel ? DDService.getAttributeShortLabel(businessObjectName, targetVal) : DDService.getAttributeLabel(businessObjectName, targetVal)))) {
                return title;
            }
            targetVal = this.getRuleData(root);
            if (LOG.isErrorEnabled()) {
                LOG.debug("Finding title in BO=" + businessObjectName + " ObjectName=" + targetVal);
            }
            if (StringUtils.isNotBlank((String)targetVal) && StringUtils.isNotBlank((String)(title = DDService.getAttributeLabel(businessObjectName, targetVal)))) {
                return title;
            }
            targetVal = root.getAttribute("name");
            if (LOG.isErrorEnabled()) {
                LOG.debug("Finding title in BO=" + businessObjectName + " ObjectName=" + targetVal);
            }
            if (StringUtils.isNotBlank((String)(title = DDService.getAttributeLabel(businessObjectName, targetVal)))) {
                return title;
            }
        } else if (StringUtils.isNotBlank((String)businessObjectText) && StringUtils.isBlank((String)businessObjectName)) {
            return businessObjectText;
        }
        return notFound;
    }

    private String getRuleData(Element root) {
        Matcher ruleTarget;
        String xPathRuleTarget = this.getXPathText(root);
        if (StringUtils.isNotBlank((String)xPathRuleTarget) && (ruleTarget = targetPattern.matcher(xPathRuleTarget)).find()) {
            xPathRuleTarget = ruleTarget.group(1);
        }
        return xPathRuleTarget;
    }

    private List<String> getXPathTerms(Element myTag) {
        ArrayList<String> xPathTerms = new ArrayList<String>();
        String allText = this.getXPathText(myTag);
        if (StringUtils.isNotBlank((String)allText)) {
            Matcher xPathTarget = xPathPattern.matcher(allText);
            int theEnd = 0;
            xPathTarget.find(theEnd);
            theEnd = xPathTarget.end() - 1;
            String firstMatch = xPathTarget.group();
            Matcher termTarget = termPattern.matcher(firstMatch);
            int theEnd2 = 0;
            while (termTarget.find(theEnd2)) {
                theEnd2 = termTarget.end() - 1;
                Matcher cleanTarget = cleanPattern.matcher(termTarget.group());
                cleanTarget.find();
                this.lastXPath = cleanTarget.group();
                xPathTerms.add(this.lastXPath);
            }
        }
        return xPathTerms;
    }
}

