/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kcb.service;

import java.util.Collection;

import org.kuali.rice.core.api.exception.RiceIllegalArgumentException;
import org.kuali.rice.kcb.api.service.MessageDelivererRegistryAPI;
import org.kuali.rice.kcb.bo.MessageDelivery;
import org.kuali.rice.kcb.deliverer.MessageDeliverer;

/**
 * This class is responsible for providing services for Message Deliverers (delivery types)
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public interface MessageDelivererRegistryService extends MessageDelivererRegistryAPI {
    /**
     * This service method is responsible for retrieving all MessageDeliverer Types.  
     * @return Collection of MessageDeliverer objects
     */
    Collection<MessageDeliverer> getAllDeliverers();

    /**
     * This service method is responsible for retrieving all MessageDeliverer Types names.  
     * @return Collection of deliverer type names
     */
    @Override
    Collection<String> getAllDelivererTypes();

    /**
     * This method returns the associated deliverer class instance for the given MessageDelivery instance.
     * @param messageDelivery
     * @return MessageDeliverer or null if not found
     * @throws RiceIllegalArgumentException if messageDelivery is null
     */
    MessageDeliverer getDeliverer(MessageDelivery messageDelivery) throws RiceIllegalArgumentException;
    
    /**
     * This method returns the associated deliverer class instance for the given deliverer name.
     * @param messageDelivererName
     * @return MessageDeliverer or null if not found
     * @throws RiceIllegalArgumentException if messageDelivererName is null
     */
    MessageDeliverer getDelivererByName(String messageDelivererName) throws RiceIllegalArgumentException;
}
