/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.ken.service;

import java.util.Collection;

import org.kuali.rice.ken.bo.NotificationChannelBo;

/**
 * Service for accessing {@link org.kuali.rice.ken.bo.NotificationChannelBo}s
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public interface NotificationChannelService {
    /**
     * This method returns all of the registered notification channels in the system.
     * @return Collection
     */
    public Collection<NotificationChannelBo> getAllNotificationChannels();
    
    /**
     * This method retrieves a specific NotificationChannel instance by id.  If none is found, it returns null.
     * @param id
     * @return NotificationChannel
     */
    public NotificationChannelBo getNotificationChannel(String id);
    
    /**
     * This method retrieves a specific NotificationChannel instance by name.  If none is found, it returns null.
     * @param id
     * @return NotificationChannel
     */
    public NotificationChannelBo getNotificationChannelByName(String name);
    
    /**
     * This method retrieves all channels in the system that can be subscribed to.
     * @return Collection
     */
    public Collection<NotificationChannelBo> getSubscribableChannels();
}
