/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.ken.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.LogManager;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/**
 * EntityResolver implementation that delegates in sequence to a list of EntityResolvers,
 * returning the first match.
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public class CompoundEntityResolver implements EntityResolver {
    private static final Logger LOG = LogManager.getLogger(CompoundEntityResolver.class);

    private final List<EntityResolver> resolvers;

    public CompoundEntityResolver(EntityResolver first, EntityResolver second) {
        this.resolvers = new ArrayList<EntityResolver>(2);
        this.resolvers.add(first);
        this.resolvers.add(second);
    }

    public CompoundEntityResolver(List<EntityResolver> resolvers) {
        this.resolvers = resolvers;
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        LOG.debug("resolveEntity: " + publicId + " " + systemId);
        for (EntityResolver resolver: resolvers) {
            LOG.debug("Invoking entity resolver: " + resolver);
            InputSource source = resolver.resolveEntity(publicId, systemId);
            if (source != null) {
                LOG.debug("source != null: " + source);
                return source;
            }
        }
        return null;
    }
}
