/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.ken.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import javax.xml.namespace.NamespaceContext;

/**
 * XPath NamespaceContext implementation that delegates in sequence to a list of NamespaceContexts,
 * returning the first match. 
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public class CompoundNamespaceContext implements NamespaceContext {
    private final List<NamespaceContext> contexts;

    public CompoundNamespaceContext(NamespaceContext first, NamespaceContext second) {
        this.contexts = new ArrayList<NamespaceContext>(2);
        this.contexts.add(first);
        this.contexts.add(second);
    }

    public CompoundNamespaceContext(List<NamespaceContext> contexts) {
        this.contexts = contexts;
    }

    @Override
    public String getNamespaceURI(String prefix) {
        if (prefix == null) {
            throw new IllegalArgumentException("The prefix cannot be null.");
        }
        for (NamespaceContext nc: contexts) {
            String uri = nc.getNamespaceURI(prefix);
            if (uri != null) {
                return uri;
            }
        }
        return null;
    }

    @Override
    public String getPrefix(String namespaceURI) {
        if (namespaceURI == null) {
            throw new IllegalArgumentException("The namespace uri cannot be null.");
        }
        for (NamespaceContext nc: contexts) {
            String prefix = nc.getPrefix(namespaceURI);
            if (prefix != null) {
                return prefix;
            }
        }
        return null;
    }

    @Override
    public Iterator getPrefixes(String namespaceURI) {
        if (namespaceURI == null) {
            throw new IllegalArgumentException("The namespace uri cannot be null.");
        }
        for (NamespaceContext nc: contexts) {
            Iterator prefixes = nc.getPrefixes(namespaceURI);
            if (prefixes != null) {
                return prefixes;
            }
        }
        return null;
    }
}
