/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.ken.util;

import org.apache.commons.lang.time.DurationFormatUtils;
import org.apache.commons.lang.time.StopWatch;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.LogManager;

/**
 * Wrapper for the Log4J performance log
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public final class PerformanceLog {
    private static final Logger LOG = LogManager.getLogger("Performance");

    public static final class PerformanceStopWatch {
        private StopWatch stopWatch = new StopWatch();
        private String message;

        public PerformanceStopWatch(String message) {
            this.message = message;
            stopWatch.start();
        }

        /**
         * This method records the duration of how long a message delivery takes.
         */
        public void recordDuration() {
            logDuration(message, stopWatch.getTime());
        }
    }

    /**
     * This method returns an instance of the logger object.
     * @return Logger
     */
    public static Logger getInstance() {
        return LOG;
    }

    /**
     * This method returns a new stop watch instance.
     * @param message
     * @return PerformanceStopWatch
     */
    public static PerformanceStopWatch startTimer(String message) {
        return new PerformanceStopWatch(message);
    }
    
    /**
     * This method logs the duration information for a given message.
     * @param message
     * @param duration
     */
    public static void logDuration(String message, long duration) {
        LOG.info(message + ": " + DurationFormatUtils.formatDurationHMS(duration) + " (" + duration+ " ms)");
    }
}
