/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kew.actionrequest.dao.impl;

import org.kuali.rice.kew.actionrequest.ActionRequestValue;
import org.kuali.rice.kew.actionrequest.dao.ActionRequestDAO;
import org.kuali.rice.kew.api.action.ActionRequestStatus;
import org.kuali.rice.kew.api.action.RecipientType;

import javax.persistence.EntityManager;
import javax.persistence.TypedQuery;
import java.util.List;

public class ActionRequestDAOJpaImpl implements ActionRequestDAO {
    
    private EntityManager entityManager;

	public EntityManager getEntityManager() {
		return this.entityManager;
	}

	public void setEntityManager(EntityManager entityManager) {
		this.entityManager = entityManager;
	}

    @Override
    public List<ActionRequestValue> findPendingRootRequestsByDocumentType(String documentTypeId) {
        TypedQuery<ActionRequestValue> query =
                entityManager.createNamedQuery("ActionRequestValue.FindPendingRootRequestsByDocumentType", ActionRequestValue.class);
        query.setParameter("documentTypeId", documentTypeId);
        query.setParameter("currentIndicator", Boolean.TRUE);
        query.setParameter("actionRequestStatus1", ActionRequestStatus.INITIALIZED.getCode());
        query.setParameter("actionRequestStatus2", ActionRequestStatus.ACTIVATED.getCode());
        return query.getResultList();
    }

    @Override
    public List<String> getRequestGroupIds(String documentId) {
        TypedQuery<String> query = entityManager.createNamedQuery("ActionRequestValue.GetRequestGroupIds", String.class);
        query.setParameter("documentId", documentId);
        query.setParameter("currentIndicator", Boolean.TRUE);
        query.setParameter("recipientTypeCd", RecipientType.GROUP.getCode());
        return query.getResultList();
    }

}
