/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kew.actiontaken.dao;

import org.kuali.rice.kew.actiontaken.ActionTakenValue;
import org.kuali.rice.kew.api.action.ActionType;

import java.sql.Timestamp;


/**
 * Data Access Object for {@link ActionTakenValue}s.
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public interface ActionTakenDao {

    /**
     * Returns the Timestamp of the last action of the given type taken against the document.
     *
     * <p>Both {@code documentId} and {@code actionType} must be supplied to this query. Otherwise an
     * {@code IllegalArgumentException} will be thrown.</p>
     *
     * @param documentId the id of the document to check
     * @param actionType the type of the action to look for
     *
     * @return the Timestamp of the last action of the given type taken against the document, or null if the document
     * has no actions
     *
     * @throws IllegalArgumentException if documentId is null or blank, or if actionType is null
     */
    Timestamp getLastActionTakenDate(String documentId, ActionType actionType);

}
