/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kew.docsearch;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;

import org.kuali.rice.kew.api.document.attribute.DocumentAttribute;
import org.kuali.rice.kew.routeheader.DocumentRouteHeaderValue;

import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.MappedSuperclass;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;

/**
 * Model bean mapped to ojb that holds a single piece of searchable data for a document.
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 *
 */
public interface SearchableAttributeValue {

	public String getAttributeDataType();

	public String getAttributeTableName();

	public boolean allowsWildcards();

	public boolean allowsCaseInsensitivity();

	public boolean allowsRangeSearches();

    public boolean isPassesDefaultValidation(String valueEntered);

    public Boolean isRangeValid(String lowerValue, String upperValue);

    public void setupAttributeValue(String value);

    public void setupAttributeValue(ResultSet resultSet, String columnName) throws SQLException;

    public String getSearchableAttributeDisplayValue();

	public String getOjbConcreteClass();

    public void setOjbConcreteClass(String ojbConcreteClass);

    public DocumentRouteHeaderValue getRouteHeader();

    public void setRouteHeader(DocumentRouteHeaderValue routeHeader);

    public String getDocumentId();

    public void setDocumentId(String documentId);

    public String getSearchableAttributeKey();

    public void setSearchableAttributeKey(String searchableAttributeKey);

    public String getSearchableAttributeValueId();

    public void setSearchableAttributeValueId(String searchableAttributeValueId);

    public Object getSearchableAttributeValue();

    public DocumentAttribute toDocumentAttribute();
}
