/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kew.document;

import org.kuali.rice.kew.rule.RuleBaseValues;
import org.kuali.rice.kew.rule.RuleDelegationBo;
import org.kuali.rice.kns.document.MaintenanceDocument;

public class RoutingRuleDelegationMaintainableBusRule extends RoutingRuleMaintainableBusRule
{

	// Name of the section in the xml file.
    protected static final String PERSON_RESP_SECTION = "delegationRule.personResponsibilities";
    // Name of the section in the xml file.
    protected static final String GROUP_RESP_SECTION = "delegationRule.groupResponsibilities";

    /**
	 * Returns the new RuleBaseValues business object. Overrides the base
	 * class method.  This business object has a different location
	 * of the RuleBaseValues.
	 */
	@Override
    protected RuleBaseValues getRuleBaseValues(MaintenanceDocument document) {
		return this.getBusObject(document).getDelegationRule();
	}

	protected RuleDelegationBo getBusObject(MaintenanceDocument document){
		return (RuleDelegationBo)document.getNewMaintainableObject().getBusinessObject();
	}
	
	/**
	 * Returns the old RuleBaseValues business object. Overrides the base
	 * class method.  This business object has a different location
	 * of the RuleBaseValues.
	 */
	@Override
    protected RuleBaseValues getOldRuleBaseValues(MaintenanceDocument document) {
		return this.getOldBusObject(document).getDelegationRule();
	}

	protected RuleDelegationBo getOldBusObject(MaintenanceDocument document){
		return (RuleDelegationBo)document.getOldMaintainableObject().getBusinessObject();
	}

	/**
	 * This overridden method returns the person section name for the delegation doc
	 *
	 * @see org.kuali.rice.kew.document.RoutingRuleMaintainableBusRule#getPersonSectionName()
	 */
	@Override
	protected String getPersonSectionName() {
		return PERSON_RESP_SECTION;
	}

	/**
	 * This overridden method returns the group section name for the delegation doc
	 *
	 * @see org.kuali.rice.kew.document.RoutingRuleMaintainableBusRule#getGroupSectionName()
	 */
	@Override
	protected String getGroupSectionName() {
		return GROUP_RESP_SECTION;
	}

}
