/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kew.engine;

import org.kuali.rice.kew.engine.node.Branch;
import org.kuali.rice.kew.engine.node.RouteNode;
import org.kuali.rice.kew.engine.node.RouteNodeInstance;
import org.kuali.rice.kew.service.KEWServiceLocator;


/**
 * Provides factory methods for creating {@link Branch} objects and {@link RouteNodeInstance} object.
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public class RoutingNodeFactory {

    public Branch createBranch(String name, Branch parentBranch, RouteNodeInstance initialNodeInstance) {
        Branch branch = new Branch();
        branch.setName(name);
        branch.setParentBranch(parentBranch);
        branch.setInitialNode(initialNodeInstance);
        initialNodeInstance.setBranch(branch);
        return branch;
    }
    
    public RouteNodeInstance createRouteNodeInstance(String documentId, RouteNode node) {
        RouteNodeInstance nodeInstance = new RouteNodeInstance();
        nodeInstance.setActive(false);
        nodeInstance.setComplete(false);
        nodeInstance.setRouteNode(node);
        nodeInstance.setDocumentId(documentId);
        return nodeInstance;
    }
    
    public RouteNode getRouteNode(RouteContext context, String name) {
        return KEWServiceLocator.getRouteNodeService().findRouteNodeByName(context.getDocument().getDocumentType().getDocumentTypeId(), name);
    }
    
}
