/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kew.engine;

import org.kuali.rice.kew.routeheader.DocumentRouteHeaderValue;

/**
 * Defines the contract to the core workflow engine.  The standard unit of work of the engine
 * is the process method.  Document must also be initialized by the WorkflowEngine when they
 * are initially created.
 * 
 * @author Kuali Rice Team (rice.collab@kuali.org)
 *
 */
public interface WorkflowEngine {
        
    void process(String documentId) throws Exception;
    
    /**
     * @throws IllegalDocumentTypeException if the given document could not be initialized successfully
     */
    void initializeDocument(DocumentRouteHeaderValue document);
}
