/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kew.engine.node;

import org.kuali.rice.kew.engine.RouteContext;

/**
 * The JoinEngine is responsible for maintaining join state and determining when the join condition
 * has been satisfied.
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public interface JoinEngine {

    public void addExpectedJoiner(RouteNodeInstance nodeInstance, Branch branch);
    
    public void addActualJoiner(RouteNodeInstance nodeInstance, Branch branch);
    
    public boolean isJoined(RouteNodeInstance nodeInstance);
    
    public RouteNodeInstance createExpectedJoinState(RouteContext context, RouteNodeInstance joinInstance, RouteNodeInstance previousNodeInstance);
}
