/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kew.engine.node;

import java.io.StringReader;

import javax.xml.parsers.DocumentBuilder;

import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.LogManager;
import org.kuali.rice.core.api.util.xml.SafeXmlUtils;
import org.kuali.rice.kew.engine.RouteContext;
import org.kuali.rice.kew.engine.RouteHelper;
import org.kuali.rice.kew.engine.node.var.PropertyScheme;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;


/**
 * A node which Logs messages to Log4j.
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public class LogNode implements SimpleNode {
    private static final Logger LOG = LogManager.getLogger(LogNode.class);

    @Override
    public SimpleResult process(RouteContext context, RouteHelper helper) throws Exception {
        LOG.error("processing");
        DocumentBuilder db = SafeXmlUtils.safeDocumentBuilderFactory().newDocumentBuilder();
        String contentFragment = context.getNodeInstance().getRouteNode().getContentFragment();
        LOG.error("contentFragment=" + contentFragment);
        Document d = db.parse(new InputSource(new StringReader(contentFragment)));
        Element e = d.getDocumentElement();
        String name = null;
        NodeList list = e.getElementsByTagName("log");
        if (list != null && list.getLength() > 0) {
            name = list.item(0).getTextContent();
        }
        list = e.getElementsByTagName("level");
        String level = "info";
        if (list != null && list.getLength() > 0) {
            level = list.item(0).getTextContent().toLowerCase();
        }
        LOG.error("doc content: "+ context.getDocument().getDocContent());
        String valueRef = e.getElementsByTagName("message").item(0).getTextContent();
        Object retrievedVal = PropertiesUtil.retrieveProperty(valueRef, PropertyScheme.LITERAL_SCHEME, context);
        LOG.error("retrieved value '" + retrievedVal + " for message '" + valueRef);
        Logger l;
        if (name == null) {
            l = LOG;
        } else {
            l = LogManager.getLogger(name);
        }
        l.log(Level.toLevel(level), retrievedVal);
        return new SimpleResult(true);
    }

}
