/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kew.engine.node;

/**
 * An implementation of a {@link NodeMatcher} which matches nodes based on the name of the node.
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public class NodeNameMatcher implements NodeMatcher {

	private String nodeName;
	
	public NodeNameMatcher(String nodeName) {
		this.nodeName = nodeName;
	}
	
	@Override
    public boolean isMatch(NodeGraphContext context) {
		return context.getCurrentNodeInstance().getName().equals(nodeName);
	}
	
}
