/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kew.engine.node;

import org.kuali.rice.kew.engine.RouteContext;
import org.kuali.rice.kew.engine.transition.SubProcessTransitionEngine;

/**
 * A simple {@link SubProcessNode} implementation which is effectively a no-op.  It simply
 * defers to the {@link SubProcessTransitionEngine} to handle the initiation of the
 * sub process.
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public class SimpleSubProcessNode implements SubProcessNode {

	@Override
    public SubProcessResult process(RouteContext context) {
		return new SubProcessResult();
	}

}
