/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kew.engine.node.dao;

import org.kuali.rice.kew.engine.node.Branch;
import org.kuali.rice.kew.engine.node.NodeState;
import org.kuali.rice.kew.engine.node.RouteNode;
import org.kuali.rice.kew.engine.node.RouteNodeInstance;

import java.util.List;



public interface RouteNodeDAO {
    public RouteNodeInstance findRouteNodeInstanceById(String nodeInstanceId);
    public List<RouteNodeInstance> getActiveNodeInstances(String documentId);
    public List<String> getActiveRouteNodeNames(String documentId);
    public List<String> getActiveSimpleRouteNodeNames(String documentId);
    public List<RouteNodeInstance> getTerminalNodeInstances(String documentId);
    public List<String> getTerminalRouteNodeNames(String documentId);
    public List<String> getCurrentRouteNodeNames(String documentId);
    public List<String> getCurrentSimpleRouteNodeNames(String documentId);
    public List getInitialNodeInstances(String documentId);
    public NodeState findNodeState(Long nodeInstanceId, String key);
    public RouteNode findRouteNodeByName(String documentTypeId, String name);
    public List<RouteNode> findFinalApprovalRouteNodes(String documentTypeId);
    public List findProcessNodeInstances(RouteNodeInstance process);
    public List findRouteNodeInstances(String documentId);
    public void deleteLinksToPreNodeInstances(RouteNodeInstance routeNodeInstance);
    public void deleteRouteNodeInstancesHereAfter(RouteNodeInstance routeNodeInstance);
    public void deleteNodeStateById(Long nodeStateId);
    public void deleteNodeStates(List statesToBeDeleted);
	
}
