/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kew.engine.node.var.schemes;

import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.LogManager;
import org.kuali.rice.kew.engine.RouteContext;
import org.kuali.rice.kew.engine.node.BranchState;
import org.kuali.rice.kew.engine.node.service.BranchService;
import org.kuali.rice.kew.engine.node.var.Property;
import org.kuali.rice.kew.engine.node.var.PropertyScheme;
import org.kuali.rice.kew.service.KEWServiceLocator;


/**
 * A property scheme that looks the property up in the state variable map
 * 
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public final class VariableScheme implements PropertyScheme {
    private static final Logger LOG = LogManager.getLogger(VariableScheme.class);

    @Override
    public String getName() {
        return "variable";
    }
    @Override
    public String getShortName() {
        return "var";
    }

    @Override
    public Object load(Property property, RouteContext context) {
//        try {
//            return PropertyUtils.getProperty(doc.getVariables(), property.locator);
            LOG.debug("getting variable: " + property.locator);
            BranchService branchService = KEWServiceLocator.getBranchService();
            String value = branchService.getScopedVariableValue(context.getNodeInstance().getBranch(), BranchState.VARIABLE_PREFIX + property.locator);
            LOG.debug("variable '" + property.locator + "': " + value);
            return value;

//        } catch (NoSuchMethodException nsme) {
//            throw new RuntimeException("Error loading resource: " + property.locator, nsme);
//        } catch (InvocationTargetException ite) {
//            throw new RuntimeException("Error loading resource: " + property.locator, ite);
//        } catch (IllegalAccessException iae) {
//            throw new RuntimeException("Error loading resource: " + property.locator, iae);
//        }
    }

    @Override
    public String toString() {
        return "[VariableScheme]";
    }
}
