/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kew.role;

import org.kuali.rice.kew.actionrequest.Recipient;
import org.kuali.rice.kim.api.responsibility.ResponsibilityAction;
import org.kuali.rice.kim.api.role.Role;

import java.util.List;

/**
 * A request recipient represented by a KIM role.
 * 
 * @author Kuali Rice Team (rice.collab@kuali.org)
 *
 */
public class KimRoleRecipient implements Recipient {

	private final Role role;
	private Recipient target;

	public KimRoleRecipient(Role role) {
		this.role = role;
	}

    public Role getRole() {
        return role;
    }

    public Recipient getTarget() {
		return this.target;
	}

	public void setTarget(Recipient target) {
		this.target = target;
	}

	public String getDisplayName() {
		throw new UnsupportedOperationException("KimRoleRecipient does not support displayName");
	}

}
