/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kew.routeheader;

import org.kuali.rice.core.api.util.xml.XmlJotter;

import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import java.io.Serializable;
import java.util.Map;

@Entity
@Table(name="KREW_DOC_HDR_CNTNT_T")
@NamedQuery(name="DocumentRouteHeaderValueContent.FindByDocumentId", query="select d from "
        + "DocumentRouteHeaderValueContent as d where d.documentId = :documentId")
public class DocumentRouteHeaderValueContent implements Serializable {

	private static final long serialVersionUID = 1L;

	@Id
	@Column(name="DOC_HDR_ID")
	private String documentId;

	@Lob
	@Basic(fetch=FetchType.LAZY)
	@Column(name="DOC_CNTNT_TXT")
    @Convert(converter = DocumentContentEncryptionConverter.class)
	private String documentContent;
		
	public DocumentRouteHeaderValueContent() {}
	
	public DocumentRouteHeaderValueContent(String documentId) {
		this.documentId = documentId;
	}
	
	public String getDocumentContent() {
		return documentContent;
	}
	public void setDocumentContent(String documentContent) {
		this.documentContent = documentContent;
	}
	public String getDocumentId() {
		return documentId;
	}
	public void setDocumentId(String documentId) {
		this.documentId = documentId;
	}

    public DocumentRouteHeaderValueContent deepCopy(Map<Object, Object> visited) {
        if (visited.containsKey(this)) {
            return (DocumentRouteHeaderValueContent)visited.get(this);
        }
        DocumentRouteHeaderValueContent copy = new DocumentRouteHeaderValueContent();
        visited.put(this, copy);
        copy.documentId = documentId;
        copy.documentContent = documentContent;
        return copy;
    }
	
	public static org.kuali.rice.kew.api.document.DocumentContent to(DocumentRouteHeaderValueContent content) {
		if (content == null) {
			return null;
		}
		org.kuali.rice.kew.api.document.DocumentContent.Builder builder = org.kuali.rice.kew.api.document.DocumentContent.Builder.create(content.getDocumentId());
		// initialize the content fields
		builder.setApplicationContent("");
		builder.setAttributeContent("");
		builder.setSearchableContent("");
		DocumentContent documentContent = new StandardDocumentContent(content.getDocumentContent());
		if (documentContent.getApplicationContent() != null) {
			builder.setApplicationContent(XmlJotter.jotNode(documentContent.getApplicationContent()));
		}
		if (documentContent.getAttributeContent() != null) {
			builder.setAttributeContent(XmlJotter.jotNode(documentContent.getAttributeContent()));
		}
		if (documentContent.getSearchableContent() != null) {
			builder.setSearchableContent(XmlJotter.jotNode(documentContent.getSearchableContent()));
		}
		return builder.build();
	}

}

