/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kew.routemodule;

import java.util.List;

import org.kuali.rice.kew.actionrequest.ActionRequestValue;
import org.kuali.rice.kew.engine.RouteContext;
import org.kuali.rice.kew.engine.node.RouteNodeInstance;
import org.kuali.rice.kew.rule.FlexRM;


/**
 * Adapts {@link FlexRM} to the {@link RouteModule} interface.
 * 
 * @see FlexRM
 * @see RouteModule
 * 
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public class FlexRMAdapter extends FlexRM implements RouteModule {

    @Override
    public List<ActionRequestValue> findActionRequests(RouteContext context) throws Exception {
        RouteNodeInstance nodeInstance = context.getNodeInstance();
        return getActionRequests(context.getDocument(), nodeInstance, nodeInstance.getRouteNode().getRouteMethodName());
    }

    /*
    public List<ActionRequestValue> findActionRequests(DocumentRouteHeaderValue routeHeader, RouteNodeInstance nodeInstance) throws WorkflowException {
        return getActionRequests(routeHeader, nodeInstance, ruleTemplateName);
    }

    public List<ActionRequestValue> findActionRequests(DocumentRouteHeaderValue routeHeader) throws WorkflowException {
        return getActionRequests(routeHeader, ruleTemplateName);
    }*/

    @Override
    public String toString() {
        return "FlexRMAdapter";
    }

    @Override
    public boolean isMoreRequestsAvailable(RouteContext context) {
        return false;
    }
    
}
