/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kew.rule.bo;

import java.util.List;
import java.util.Map;

import org.kuali.rice.kew.rule.RuleDelegationBo;
import org.kuali.rice.kew.rule.web.WebRuleUtils;
import org.kuali.rice.kns.inquiry.KualiInquirableImpl;
import org.kuali.rice.kns.web.ui.Section;
import org.kuali.rice.krad.bo.BusinessObject;

/**
 * Inquirable implementation for KEW rule delegations.
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 *
 */
public class RuleDelegationInquirableImpl extends KualiInquirableImpl {

	@Override
	public Object retrieveDataObject(Map fieldValues){
		RuleDelegationBo rule = (RuleDelegationBo)super.retrieveDataObject(fieldValues);
		WebRuleUtils.populateRuleMaintenanceFields(rule.getDelegationRule());
		return rule;
    }

	@Override
    public BusinessObject getBusinessObject(Map fieldValues) {
		RuleDelegationBo rule = (RuleDelegationBo)super.getBusinessObject(fieldValues);
		WebRuleUtils.populateRuleMaintenanceFields(rule.getDelegationRule());
		return rule;
	}

	@Override
    public List getSections(BusinessObject bo) {
		List<Section> sections = super.getSections(bo);
		
		return WebRuleUtils.customizeSections(((RuleDelegationBo)bo).getDelegationRule(), sections, true);
		
	}

}
