/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kew.service.impl;

import org.apache.commons.lang.StringUtils;
import org.kuali.rice.kim.api.KimConstants;
import org.kuali.rice.kim.api.permission.Permission;
import org.kuali.rice.kns.kim.permission.PermissionTypeServiceBase;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * Gives people with a Backdoor Restriction permission the ability to backdoor as anyone
 *
 * @author IU Kuali Rice Team (rice.collab@kuali.org)
 */

public class BackdoorRestrictionPermissionTypeServiceImpl extends PermissionTypeServiceBase {
    @Override
    protected List<Permission> performPermissionMatches(Map<String, String> requestedDetails,
            List<Permission> permissionsList) {
        // pull all the potential app codes from the permission list
        Set<String> permissionAppCodes = new HashSet<String>(permissionsList.size());
        for (Permission permission : permissionsList) {
            String appCode = permission.getAttributes().get(KimConstants.AttributeConstants.APP_CODE);
            if (StringUtils.isNotBlank(appCode)) {
                permissionAppCodes.add(appCode);
            }
        }
        String requestedAppCode = requestedDetails.get(KimConstants.AttributeConstants.APP_CODE);
        // re-loop over the permissions and build a new list of the ones which have the
        // matching app codes in their details
        List<Permission> matchingPermissions = new ArrayList<Permission>();
        for (Permission permission : permissionsList) {
            String currentAppCode = permission.getAttributes().get(KimConstants.AttributeConstants.APP_CODE);
            if (StringUtils.isNotEmpty(requestedAppCode) && requestedAppCode.equals(currentAppCode)) {
                matchingPermissions.add(permission);
            }
        }

        return matchingPermissions;
    }
}

