/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kew.util;

import java.io.Serializable;

import org.kuali.rice.kew.actionrequest.ActionRequestValue;


/**
 * A user, workgroup, or role who is responsible for an Action Request.
 * 
 * @see ActionRequestValue
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public class ResponsibleParty implements Serializable {

	private static final long serialVersionUID = 6788236688949489851L;

	private String principalId;
    private String groupId;
    private String roleName;

    public ResponsibleParty() {
    }

    public static ResponsibleParty fromGroupId(String groupId) {
		ResponsibleParty responsibleParty = new ResponsibleParty();
		responsibleParty.setGroupId(groupId);
		return responsibleParty;
	}
	
	public static ResponsibleParty fromPrincipalId(String principalId) {
		ResponsibleParty responsibleParty = new ResponsibleParty();
		responsibleParty.setPrincipalId(principalId);
		return responsibleParty;
	}
	
	public static ResponsibleParty fromRoleName(String roleName) {
		ResponsibleParty responsibleParty = new ResponsibleParty();
		responsibleParty.setRoleName(roleName);
		return responsibleParty;
	}

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer("[");
        if (principalId != null) {
            sb.append("user=");
            sb.append(principalId.toString());
        } else if (groupId != null) {
            sb.append("groupID=");
            sb.append(groupId.toString());
        } else if (roleName != null) {
            sb.append("roleName=");
            sb.append(roleName);
        }
        sb.append("]");
        return sb.toString();
    }

    public String getGroupId() {
        return groupId;
    }

    public String getPrincipalId() {
        return principalId;
    }
    
    public void setPrincipalId(String principalId) {
        this.principalId = principalId;
    }

    public String getRoleName() {
        return roleName;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public void setRoleName(String roleName) {
        this.roleName = roleName;
    }

    public boolean isPrincipal() {
        return getPrincipalId() != null;
    }

    public boolean isGroup() {
        return getGroupId() != null;
    }

    public boolean isRole() {
        return getRoleName() != null;
    }
    
}
