/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kim.bo.ui;

import java.util.Iterator;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;

import org.apache.commons.lang.StringUtils;
import org.kuali.rice.kim.api.KimConstants;
import org.kuali.rice.kim.api.permission.Permission;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.krad.data.jpa.PortableSequenceGenerator;

/**
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
@Entity
@Table(name = "KRIM_PND_ROLE_PERM_T")
public class KimDocumentRolePermission extends KimDocumentBoActivatableBase {

    private static final long serialVersionUID = 1L;

    @PortableSequenceGenerator(name = "KRIM_ROLE_PERM_ID_S")
    @GeneratedValue(generator = "KRIM_ROLE_PERM_ID_S")
    @Id
    @Column(name = "ROLE_PERM_ID")
    protected String rolePermissionId;

    @Column(name = "ROLE_ID")
    protected String roleId;

    @Column(name = "PERM_ID")
    protected String permissionId;

    @Transient
    protected Permission permission;

    @Transient
    protected String name;

    @Transient
    protected String namespaceCode;

    public String getPermissionId() {
        return permissionId;
    }

    public String getRoleId() {
        return roleId;
    }

    public String getRolePermissionId() {
        return rolePermissionId;
    }

    public void setPermissionId(String permissionId) {
        this.permissionId = permissionId;
    }

    public void setRoleId(String roleId) {
        this.roleId = roleId;
    }

    public void setRolePermissionId(String rolePermissionId) {
        this.rolePermissionId = rolePermissionId;
    }

    public Permission getPermission() {
        if (null != permissionId) {
            if (permission == null || !StringUtils.equals(permission.getId(), permissionId)) {
                permission = KimApiServiceLocator.getPermissionService().getPermission(permissionId);
            }
        }
        return permission;
    }

    public String getPermissionDetailValues() {
        Permission perm = getPermission();
        StringBuilder sb = new StringBuilder();
        if (perm.getAttributes() != null) {
            Iterator<String> keyIter = perm.getAttributes().keySet().iterator();
            while (keyIter.hasNext()) {
                String key = keyIter.next();
                sb.append(key).append('=').append(perm.getAttributes().get(key));
                if (keyIter.hasNext()) {
                    sb.append(KimConstants.KimUIConstants.COMMA_SEPARATOR).append(" ");
                }
            }
        }
        return sb.toString();
    }

    public void setPermission(Permission permission) {
        this.permission = permission;
    }

    public String getName() {
        if (null == permission) {
            getPermission();
        }
        if (null == permission) {
            return "";
        }
        return permission.getName();
    }

    public String getNamespaceCode() {
        if (null == permission) {
            getPermission();
        }
        if (null == permission) {
            return "";
        }
        return permission.getNamespaceCode();
    }
}
