/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kim.rule.event.ui;

import org.kuali.rice.kim.bo.ui.PersonDocumentRole;
import org.kuali.rice.kim.document.IdentityManagementPersonDocument;
import org.kuali.rice.kim.rule.ui.AddRoleRule;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.rules.rule.BusinessRule;
import org.kuali.rice.krad.rules.rule.event.DocumentEventBase;

public class AddRoleEvent  extends DocumentEventBase {
	private PersonDocumentRole role;

	public AddRoleEvent(String errorPathPrefix, IdentityManagementPersonDocument document) {
        super("adding role document " + getDocumentId(document), errorPathPrefix, document);
    }

    public AddRoleEvent(String errorPathPrefix, Document document, PersonDocumentRole role) {
        this(errorPathPrefix, (IdentityManagementPersonDocument) document);
        this.role = role;
    }

    @Override
    public Class<? extends BusinessRule> getRuleInterfaceClass() {
        return AddRoleRule.class;
    }

    @Override
    public boolean invokeRuleMethod(BusinessRule rule) {
        return ((AddRoleRule) rule).processAddRole(this);
    }

	public PersonDocumentRole getRole() {
		return this.role;
	}

	public void setRole(PersonDocumentRole role) {
		this.role = role;
	}


}
