/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kcb.quartz;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ProcessingResult<T> {
    private List<Failure<T>> failures = new ArrayList<Failure<T>>();
    private List<T> successes = new ArrayList<T>();

    public List<Failure<T>> getFailures() {
        return this.failures;
    }

    public List<T> getSuccesses() {
        return this.successes;
    }

    public void addFailure(Failure<T> o) {
        this.failures.add(o);
    }

    public void addAllFailures(Collection<Failure<T>> c) {
        this.failures.addAll(c);
    }

    public void addSuccess(T o) {
        this.successes.add(o);
    }

    public void addAllSuccesses(Collection<T> c) {
        this.successes.addAll(c);
    }

    public void add(ProcessingResult<T> result) {
        this.failures.addAll(result.getFailures());
        this.successes.addAll(result.getSuccesses());
    }

    public String toString() {
        return "[ProcessingResults: successes(" + this.successes.size() + ")=" + String.valueOf(this.successes) + ", failures(" + this.failures.size() + ")=" + String.valueOf(this.failures) + "]";
    }

    public static class Failure<T> {
        private T item;
        private Throwable exception;
        private String message;

        public Failure(T item) {
            this.item = item;
        }

        public Failure(String message) {
            this(null, null, message);
        }

        public Failure(Throwable exception) {
            this(null, exception, null);
        }

        public Failure(Throwable exception, String message) {
            this(null, exception, message);
        }

        public Failure(T item, Throwable exception) {
            this(item, exception, null);
        }

        public Failure(T item, String message) {
            this(item, null, message);
        }

        public Failure(T item, Throwable exception, String message) {
            this.item = item;
            this.exception = exception;
            this.message = message;
        }

        public T getItem() {
            return this.item;
        }

        public Throwable getException() {
            return this.exception;
        }

        public String getMessage() {
            return this.message;
        }
    }
}

