/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.ken.postprocessor.kew;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.List;
import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.rice.ken.bo.NotificationMessageDelivery;
import org.kuali.rice.ken.core.GlobalNotificationServiceLocator;
import org.kuali.rice.ken.service.NotificationMessageDeliveryService;
import org.kuali.rice.ken.service.NotificationService;
import org.kuali.rice.ken.util.Util;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kew.api.WorkflowDocumentFactory;
import org.kuali.rice.kew.api.action.ActionType;
import org.kuali.rice.kew.framework.postprocessor.ActionTakenEvent;
import org.kuali.rice.kew.framework.postprocessor.AfterProcessEvent;
import org.kuali.rice.kew.framework.postprocessor.BeforeProcessEvent;
import org.kuali.rice.kew.framework.postprocessor.DeleteEvent;
import org.kuali.rice.kew.framework.postprocessor.DocumentLockingEvent;
import org.kuali.rice.kew.framework.postprocessor.DocumentRouteLevelChange;
import org.kuali.rice.kew.framework.postprocessor.DocumentRouteStatusChange;
import org.kuali.rice.kew.framework.postprocessor.PostProcessor;
import org.kuali.rice.kew.framework.postprocessor.ProcessDocReport;

public class NotificationPostProcessor
implements PostProcessor {
    private static final Logger LOG = LogManager.getLogger(NotificationPostProcessor.class);
    NotificationService notificationService;
    NotificationMessageDeliveryService msgDeliverySvc = GlobalNotificationServiceLocator.getInstance().getNotificationMessageDeliveryService();

    public NotificationPostProcessor() {
        this.notificationService = GlobalNotificationServiceLocator.getInstance().getNotificationService();
    }

    public ProcessDocReport doActionTaken(ActionTakenEvent event) throws Exception {
        LOG.debug("ENTERING NotificationPostProcessor.doActionTaken() for Notification action item with document ID: " + event.getDocumentId());
        LOG.debug("ACTION TAKEN=" + String.valueOf(event.getActionTaken().getActionTaken()));
        String actionTakenCode = event.getActionTaken().getActionTaken().getCode();
        Properties p = new Properties();
        WorkflowDocument doc = WorkflowDocumentFactory.loadDocument((String)event.getActionTaken().getPrincipalId(), (String)event.getDocumentId());
        try {
            p.load(new ByteArrayInputStream(doc.getAttributeContent().getBytes()));
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        String internalCommand = p.getProperty("internal_command");
        if (Boolean.valueOf(internalCommand).booleanValue()) {
            LOG.info("Internal command detected by NotificationPostProcessor - will not invoke KEN");
            return new ProcessDocReport(true, "");
        }
        LOG.info("NotificationPostProcessor detected end-user action " + String.valueOf(event.getActionTaken().getActionTaken()) + " on document " + event.getActionTaken().getDocumentId());
        if (actionTakenCode.equals("K") || actionTakenCode.equals("F")) {
            LOG.debug("User has taken either acknowledge or fy action (action code=" + actionTakenCode + ") for Notification action item with document ID: " + event.getDocumentId() + ".  We are now changing the status of the associated NotificationMessageDelivery to REMOVED.");
            try {
                NotificationMessageDelivery nmd = this.msgDeliverySvc.getNotificationMessageDeliveryByDelivererId(event.getDocumentId());
                if (nmd == null) {
                    throw new RuntimeException("Could not find message delivery from workflow document " + event.getDocumentId() + " to dismiss");
                }
                String cause = "K".equals(actionTakenCode) ? "ack" : ("F".equals(actionTakenCode) ? "fyi" : "unknown");
                LOG.info("Dismissing message id " + nmd.getId() + " due to cause: " + cause);
                this.notificationService.dismissNotificationMessageDelivery(nmd.getId(), Util.getNotificationSystemUser(), cause);
            }
            catch (Exception e) {
                throw new RuntimeException("Error dismissing message", e);
            }
        }
        LOG.debug("LEAVING NotificationPostProcessor.doActionTaken() for Notification action item with document ID: " + event.getDocumentId());
        return new ProcessDocReport(true);
    }

    public ProcessDocReport afterActionTaken(ActionType performed, ActionTakenEvent event) throws Exception {
        return new ProcessDocReport(true, "");
    }

    public ProcessDocReport doDeleteRouteHeader(DeleteEvent arg0) throws Exception {
        return new ProcessDocReport(true, "");
    }

    public ProcessDocReport doRouteLevelChange(DocumentRouteLevelChange arg0) throws Exception {
        return new ProcessDocReport(true, "");
    }

    public ProcessDocReport doRouteStatusChange(DocumentRouteStatusChange arg0) throws Exception {
        return new ProcessDocReport(true, "");
    }

    public ProcessDocReport beforeProcess(BeforeProcessEvent beforeProcessEvent) throws Exception {
        return new ProcessDocReport(true, "");
    }

    public ProcessDocReport afterProcess(AfterProcessEvent afterProcessEvent) throws Exception {
        return new ProcessDocReport(true, "");
    }

    public List<String> getDocumentIdsToLock(DocumentLockingEvent documentLockingEvent) throws Exception {
        return null;
    }
}

