/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.actions;

import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.ThreadContext;
import org.kuali.rice.kew.actionrequest.ActionRequestValue;
import org.kuali.rice.kew.actions.ActionTakenEvent;
import org.kuali.rice.kew.actiontaken.ActionTakenValue;
import org.kuali.rice.kew.api.KewApiConstants;
import org.kuali.rice.kew.api.exception.InvalidActionTakenException;
import org.kuali.rice.kew.doctype.DocumentTypePolicy;
import org.kuali.rice.kew.routeheader.DocumentRouteHeaderValue;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.kuali.rice.kim.api.identity.principal.PrincipalContract;

public class CompleteAction
extends ActionTakenEvent {
    private static final Logger LOG = LogManager.getLogger(CompleteAction.class);

    public CompleteAction(DocumentRouteHeaderValue rh, PrincipalContract principal) {
        super("C", rh, principal);
    }

    public CompleteAction(DocumentRouteHeaderValue rh, PrincipalContract principal, String annotation) {
        super("C", rh, principal, annotation);
    }

    @Override
    public String validateActionRules() {
        return this.validateActionRules(this.getActionRequestService().findAllPendingRequests(this.routeHeader.getDocumentId()));
    }

    @Override
    public String validateActionRules(List<ActionRequestValue> actionRequests) {
        if (!this.getRouteHeader().isValidActionToTake(this.getActionPerformedCode())) {
            return "Document is not in a state to be completed";
        }
        List<ActionRequestValue> filteredActionRequests = this.filterActionRequestsByCode(actionRequests, "C");
        if (!this.isActionCompatibleRequest((List)filteredActionRequests)) {
            return "No request for the user is compatible with the COMPLETE action";
        }
        return "";
    }

    public boolean isActionCompatibleRequest(List requests) {
        if (requests.isEmpty()) {
            return true;
        }
        if (this.routeHeader.isStateInitiated() || this.routeHeader.isStateSaved()) {
            return true;
        }
        boolean actionCompatible = false;
        Iterator ars = requests.iterator();
        ActionRequestValue actionRequest = null;
        while (ars.hasNext()) {
            actionRequest = (ActionRequestValue)ars.next();
            String request = actionRequest.getActionRequested();
            if (!"F".equals(request) && !"K".equals(request) && !"A".equals(request) && !"C".equals(request)) continue;
            actionCompatible = true;
            break;
        }
        return actionCompatible;
    }

    @Override
    public void recordAction() throws InvalidActionTakenException {
        DocumentTypePolicy allowUnrequested;
        ThreadContext.put((String)"docId", (String)this.getRouteHeader().getDocumentId());
        this.updateSearchableAttributesIfPossible();
        LOG.debug("Completing document : " + this.annotation);
        List<ActionRequestValue> actionRequests = this.getActionRequestService().findAllValidRequests(this.getPrincipal().getPrincipalId(), this.getDocumentId(), "C");
        if ((actionRequests == null || actionRequests.isEmpty()) && (allowUnrequested = this.getRouteHeader().getDocumentType().getAllowUnrequestedActionPolicy()) != null && !allowUnrequested.getPolicyValue().booleanValue()) {
            throw new InvalidActionTakenException("No request for the user is compatible with the COMPLETE action. Doctype policy ALLOW_UNREQUESTED_ACTION is set to false and someone else likely just took action on the document.");
        }
        LOG.debug("Checking to see if the action is legal");
        String errorMessage = this.validateActionRules(actionRequests);
        if (!StringUtils.isEmpty((String)errorMessage)) {
            throw new InvalidActionTakenException(errorMessage);
        }
        LOG.debug("Record the complete action");
        ActionTakenValue actionTaken = this.saveActionTaken(this.findDelegatorForActionRequests(actionRequests));
        LOG.debug("Deactivate all pending action requests");
        this.getActionRequestService().deactivateRequests(actionTaken, actionRequests);
        this.notifyActionTaken(actionTaken);
        boolean isException = this.getRouteHeader().isInException();
        boolean isSaved = this.getRouteHeader().isStateSaved();
        if (isException || isSaved) {
            String oldStatus = this.getRouteHeader().getDocRouteStatus();
            LOG.debug("Moving document back to Enroute from " + (String)KewApiConstants.DOCUMENT_STATUSES.get(oldStatus));
            this.getRouteHeader().markDocumentEnroute();
            String newStatus = this.getRouteHeader().getDocRouteStatus();
            this.notifyStatusChange(newStatus, oldStatus);
            DocumentRouteHeaderValue routeHeaderValue = KEWServiceLocator.getRouteHeaderService().saveRouteHeader(this.getRouteHeader());
            this.setRouteHeader(routeHeaderValue);
        }
    }
}

