/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.actions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.ThreadContext;
import org.kuali.rice.kew.actionrequest.ActionRequestValue;
import org.kuali.rice.kew.actionrequest.Recipient;
import org.kuali.rice.kew.actions.ActionTakenEvent;
import org.kuali.rice.kew.actiontaken.ActionTakenValue;
import org.kuali.rice.kew.api.action.AdHocRevoke;
import org.kuali.rice.kew.api.exception.InvalidActionTakenException;
import org.kuali.rice.kew.routeheader.DocumentRouteHeaderValue;
import org.kuali.rice.kim.api.identity.principal.PrincipalContract;

public class RevokeAdHocAction
extends ActionTakenEvent {
    private static final Logger LOG = LogManager.getLogger(RevokeAdHocAction.class);
    private String actionRequestId;
    private AdHocRevoke revoke;

    public RevokeAdHocAction(DocumentRouteHeaderValue routeHeader, PrincipalContract principal) {
        super("V", routeHeader, principal);
    }

    public RevokeAdHocAction(DocumentRouteHeaderValue routeHeader, PrincipalContract principal, String actionRequestId, String annotation) {
        super("V", routeHeader, principal, annotation);
        this.actionRequestId = actionRequestId;
    }

    public RevokeAdHocAction(DocumentRouteHeaderValue routeHeader, PrincipalContract principal, AdHocRevoke revoke, String annotation) {
        super("V", routeHeader, principal, annotation);
        this.revoke = revoke;
    }

    @Override
    public String validateActionRules() {
        if (!this.getRouteHeader().isValidActionToTake(this.getActionPerformedCode())) {
            return "Revoke adhoc request is not valid on this document";
        }
        return "";
    }

    @Override
    public String validateActionRules(List<ActionRequestValue> actionRequests) {
        return this.validateActionRules();
    }

    @Override
    public void recordAction() throws InvalidActionTakenException {
        ThreadContext.put((String)"docId", (String)this.getRouteHeader().getDocumentId());
        this.updateSearchableAttributesIfPossible();
        String errorMessage = this.validateActionRules();
        if (!StringUtils.isEmpty((String)errorMessage)) {
            throw new InvalidActionTakenException(errorMessage);
        }
        LOG.debug("Revoking adhoc request : " + this.annotation);
        ArrayList<ActionRequestValue> requestsToRevoke = new ArrayList<ActionRequestValue>();
        List<ActionRequestValue> actionRequests = this.getActionRequestService().findPendingRootRequestsByDocId(this.getDocumentId());
        for (ActionRequestValue actionRequest : actionRequests) {
            if (!this.matchesActionRequest(this.revoke, actionRequest)) continue;
            requestsToRevoke.add(actionRequest);
        }
        if (requestsToRevoke.isEmpty() && this.actionRequestId != null) {
            throw new InvalidActionTakenException("Failed to revoke action request with id " + this.actionRequestId + ".  ID does not represent a valid ad hoc request!");
        }
        Recipient delegator = this.findDelegatorForActionRequests(actionRequests);
        LOG.debug("Record the revoke action");
        ActionTakenValue actionTaken = this.saveActionTaken(delegator);
        LOG.debug("Revoke all matching action requests, number of matching requests: " + requestsToRevoke.size());
        this.getActionRequestService().deactivateRequests(actionTaken, requestsToRevoke);
        this.notifyActionTaken(actionTaken);
    }

    protected boolean matchesActionRequest(AdHocRevoke adHocRevokeCommand, ActionRequestValue actionRequest) {
        if (!actionRequest.isAdHocRequest()) {
            return false;
        }
        if (this.actionRequestId != null) {
            return this.actionRequestId.equals(actionRequest.getActionRequestId());
        }
        if (adHocRevokeCommand != null) {
            boolean principalOrGroupId;
            boolean bl = principalOrGroupId = !CollectionUtils.isEmpty((Collection)adHocRevokeCommand.getPrincipalIds()) || !CollectionUtils.isEmpty((Collection)adHocRevokeCommand.getGroupIds());
            if (!CollectionUtils.isEmpty((Collection)adHocRevokeCommand.getNodeNames()) && !adHocRevokeCommand.getNodeNames().contains(actionRequest.getNodeInstance().getName())) {
                return false;
            }
            if (actionRequest.isUserRequest() && !CollectionUtils.isEmpty((Collection)adHocRevokeCommand.getPrincipalIds())) {
                return adHocRevokeCommand.getPrincipalIds().contains(actionRequest.getPrincipalId());
            }
            if (actionRequest.isGroupRequest() && !CollectionUtils.isEmpty((Collection)adHocRevokeCommand.getGroupIds())) {
                return adHocRevokeCommand.getGroupIds().contains(actionRequest.getGroupId());
            }
            return !principalOrGroupId;
        }
        return true;
    }
}

