/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.impl.document;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import org.kuali.rice.kew.doctype.ApplicationDocumentStatus;
import org.kuali.rice.kew.doctype.bo.DocumentType;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.springframework.util.CollectionUtils;

public class ApplicationDocumentStatusUtils {
    public static LinkedHashMap<String, List<String>> getApplicationDocumentStatusCategories(String documentTypeName) {
        DocumentType documentType = KEWServiceLocator.getDocumentTypeService().findByName(documentTypeName);
        return ApplicationDocumentStatusUtils.getApplicationDocumentStatusCategories(documentType);
    }

    public static LinkedHashMap<String, List<String>> getApplicationDocumentStatusCategories(DocumentType documentType) {
        LinkedHashMap<String, List<String>> results = new LinkedHashMap<String, List<String>>();
        if (documentType != null && !CollectionUtils.isEmpty(documentType.getValidApplicationStatuses())) {
            ApplicationDocumentStatusUtils.sortBySequenceNumber(documentType.getValidApplicationStatuses());
            for (ApplicationDocumentStatus status : documentType.getValidApplicationStatuses()) {
                if (status.getCategoryName() == null) continue;
                if (!results.containsKey(status.getCategoryName())) {
                    results.put(status.getCategoryName(), new ArrayList());
                }
                results.get(status.getCategoryName()).add(status.getStatusName());
            }
        }
        return results;
    }

    private static void sortBySequenceNumber(List<ApplicationDocumentStatus> statuses) {
        Collections.sort(statuses, new Comparator<ApplicationDocumentStatus>(){

            @Override
            public int compare(ApplicationDocumentStatus o1, ApplicationDocumentStatus o2) {
                if (o1 == null || o2 == null) {
                    throw new IllegalArgumentException();
                }
                if (o1.getSequenceNumber() == null) {
                    if (o2.getSequenceNumber() == null) {
                        return 0;
                    }
                    return -1;
                }
                if (o2.getSequenceNumber() == null) {
                    return 1;
                }
                return o1.getSequenceNumber().compareTo(o2.getSequenceNumber());
            }
        });
    }
}

