/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.impl.document.search;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.kns.web.ui.Field;
import org.kuali.rice.kns.web.ui.Row;

class FormFields {
    private final Collection<Row> rows;

    FormFields(Collection<Row> rows) {
        this.rows = rows;
    }

    Map<String, String[]> getFieldValues() {
        HashMap<String, String[]> values = new HashMap<String, String[]>();
        for (Field field : this.getFields()) {
            String[] value = !Field.MULTI_VALUE_FIELD_TYPES.contains(field.getFieldType()) ? new String[]{field.getPropertyValue()} : field.getPropertyValues();
            values.put(field.getPropertyName(), value);
        }
        return values;
    }

    Field getField(final String name) {
        return (Field)Iterables.tryFind(this.getFields(), (Predicate)new Predicate<Field>(){

            public boolean apply(@Nullable Field input) {
                return StringUtils.equals((String)name, (String)input.getPropertyName());
            }
        }).orNull();
    }

    void setFieldValue(String name, String value) {
        this.setFieldValue(name, new String[]{value});
    }

    void setFieldValue(String name, String[] value) {
        this.setFieldValues(Collections.singletonMap(name, value));
    }

    void setFieldValues(Map<String, String[]> values) {
        for (Field field : this.getFields()) {
            Object[] value;
            if (!StringUtils.isNotBlank((String)field.getPropertyName()) || !ArrayUtils.isNotEmpty((Object[])(value = values.get(field.getPropertyName())))) continue;
            this.setFieldValue(field, (String[])value);
        }
    }

    List<Field> getFieldList() {
        return Lists.newArrayList(this.getFields());
    }

    void setFieldValue(Field field, String[] values) {
        if (!Field.MULTI_VALUE_FIELD_TYPES.contains(field.getFieldType())) {
            field.setPropertyValue(CollectionUtils.get((Object)values, (int)0));
        } else {
            field.setPropertyValues(values);
        }
    }

    Iterable<Field> getFields() {
        return Iterables.concat((Iterable)Iterables.transform(this.rows, (Function)new Function<Row, Iterable<Field>>(this){

            public Iterable<Field> apply(@Nullable Row row) {
                return row.getFields();
            }
        }));
    }
}

