/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.impl.service;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.joda.time.DateTime;
import org.kuali.rice.kew.api.KewApiServiceLocator;
import org.kuali.rice.kew.api.doctype.DocumentType;
import org.kuali.rice.kew.api.doctype.DocumentTypeContract;
import org.kuali.rice.kew.api.doctype.DocumentTypeService;
import org.kuali.rice.kew.api.document.Document;
import org.kuali.rice.kew.api.document.DocumentStatus;
import org.kuali.rice.kew.docsearch.DocumentSearchCriteriaEbo;
import org.kuali.rice.kew.doctype.bo.DocumentTypeEBO;
import org.kuali.rice.krad.bo.ExternalizableBusinessObject;
import org.kuali.rice.krad.service.impl.RemoteModuleServiceBase;

public class KewRemoteModuleService
extends RemoteModuleServiceBase {
    protected DocumentTypeService docTypeService = null;

    public <T extends ExternalizableBusinessObject> T getExternalizableBusinessObject(Class<T> businessObjectClass, Map<String, Object> fieldValues) {
        if (DocumentTypeEBO.class.isAssignableFrom(businessObjectClass)) {
            if (fieldValues.containsKey("name")) {
                return (T)org.kuali.rice.kew.doctype.bo.DocumentType.from((DocumentTypeContract)this.getDocumentTypeService().getDocumentTypeByName((String)fieldValues.get("name")));
            }
            if (fieldValues.containsKey("documentTypeId")) {
                return (T)org.kuali.rice.kew.doctype.bo.DocumentType.from((DocumentTypeContract)this.getDocumentTypeService().getDocumentTypeById(fieldValues.get("documentTypeId").toString()));
            }
            if (fieldValues.containsKey("id")) {
                return (T)org.kuali.rice.kew.doctype.bo.DocumentType.from((DocumentTypeContract)this.getDocumentTypeService().getDocumentTypeById(fieldValues.get("id").toString()));
            }
        } else if (DocumentSearchCriteriaEbo.class.isAssignableFrom(businessObjectClass) && fieldValues.containsKey("documentId")) {
            return (T)this.createDocumentSearchEbo(KewApiServiceLocator.getWorkflowDocumentService().getDocument(fieldValues.get("documentId").toString()));
        }
        return null;
    }

    private DocumentSearchCriteriaEbo createDocumentSearchEbo(final Document doc) {
        return new DocumentSearchCriteriaEbo(){

            @Override
            public String getApplicationDocumentId() {
                return doc.getApplicationDocumentId();
            }

            @Override
            public DocumentStatus getStatus() {
                return doc.getStatus();
            }

            @Override
            public String getApplicationDocumentStatus() {
                return doc.getApplicationDocumentStatus();
            }

            @Override
            public String getTitle() {
                return doc.getTitle();
            }

            @Override
            public String getDocumentTypeName() {
                return doc.getDocumentTypeName();
            }

            @Override
            public String getInitiatorPrincipalId() {
                return doc.getInitiatorPrincipalId();
            }

            @Override
            public String getDocumentId() {
                return doc.getDocumentId();
            }

            @Override
            public DateTime getDateCreated() {
                return doc.getDateCreated();
            }

            public void refresh() {
            }
        };
    }

    public <T extends ExternalizableBusinessObject> List<T> getExternalizableBusinessObjectsList(Class<T> businessObjectClass, Map<String, Object> fieldValues) {
        if (!fieldValues.isEmpty()) {
            throw new IllegalStateException("fieldValues must be empty");
        }
        ArrayList<org.kuali.rice.kew.doctype.bo.DocumentType> ebos = new ArrayList<org.kuali.rice.kew.doctype.bo.DocumentType>();
        if (DocumentTypeEBO.class.isAssignableFrom(businessObjectClass)) {
            List docTypes = this.getDocumentTypeService().findAllDocumentTypes();
            for (DocumentType docType : docTypes) {
                ebos.add(org.kuali.rice.kew.doctype.bo.DocumentType.from((DocumentTypeContract)docType));
            }
            return ebos;
        }
        return Collections.emptyList();
    }

    public boolean isExternalizableBusinessObjectLookupable(Class boClass) {
        return this.isExternalizable(boClass);
    }

    public boolean isExternalizableBusinessObjectInquirable(Class boClass) {
        return this.isExternalizable(boClass);
    }

    public boolean isExternalizable(Class boClazz) {
        if (boClazz == null) {
            return false;
        }
        if (DocumentTypeEBO.class.isAssignableFrom(boClazz)) {
            return true;
        }
        if (DocumentSearchCriteriaEbo.class.isAssignableFrom(boClazz)) {
            return true;
        }
        return ExternalizableBusinessObject.class.isAssignableFrom(boClazz);
    }

    public List<String> listPrimaryKeyFieldNames(Class boClass) {
        if (DocumentTypeEBO.class.isAssignableFrom(boClass)) {
            ArrayList<String> pkFields = new ArrayList<String>(1);
            pkFields.add("documentTypeId");
            return pkFields;
        }
        if (DocumentSearchCriteriaEbo.class.isAssignableFrom(boClass)) {
            ArrayList<String> pkFields = new ArrayList<String>(1);
            pkFields.add("documentId");
            return pkFields;
        }
        return Collections.emptyList();
    }

    public List<List<String>> listAlternatePrimaryKeyFieldNames(Class businessObjectInterfaceClass) {
        if (DocumentTypeEBO.class.isAssignableFrom(businessObjectInterfaceClass)) {
            ArrayList<List<String>> retList = new ArrayList<List<String>>();
            ArrayList<String> keyList = new ArrayList<String>();
            keyList.add("name");
            retList.add(keyList);
            return retList;
        }
        return null;
    }

    protected synchronized DocumentTypeService getDocumentTypeService() {
        if (this.docTypeService == null) {
            this.docTypeService = KewApiServiceLocator.getDocumentTypeService();
        }
        return this.docTypeService;
    }
}

