/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.impl.support.krms;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.rice.core.api.config.ConfigurationException;
import org.kuali.rice.core.api.reflect.ObjectDefinition;
import org.kuali.rice.core.api.resourceloader.GlobalResourceLoader;
import org.kuali.rice.kew.actionrequest.ActionRequestValue;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kew.api.extension.ExtensionDefinition;
import org.kuali.rice.kew.api.extension.ExtensionDefinitionContract;
import org.kuali.rice.kew.api.extension.ExtensionRepositoryService;
import org.kuali.rice.kew.api.extension.ExtensionUtils;
import org.kuali.rice.kew.engine.RouteContext;
import org.kuali.rice.kew.engine.node.NodeState;
import org.kuali.rice.kew.engine.node.RouteNode;
import org.kuali.rice.kew.engine.node.RouteNodeUtils;
import org.kuali.rice.kew.engine.node.service.RouteNodeService;
import org.kuali.rice.kew.framework.support.krms.RulesEngineExecutor;
import org.kuali.rice.kew.impl.peopleflow.PeopleFlowRouteModule;
import org.kuali.rice.kew.routemodule.RouteModule;
import org.kuali.rice.kew.util.ResponsibleParty;
import org.kuali.rice.krms.api.KrmsApiServiceLocator;
import org.kuali.rice.krms.api.engine.Engine;
import org.kuali.rice.krms.api.engine.EngineResults;
import org.w3c.dom.Element;

public class RulesEngineRouteModule
implements RouteModule {
    private static final Logger LOG = LogManager.getLogger(RulesEngineRouteModule.class);
    private static final String RULES_ENGINE_ELEMENT = "rulesEngine";
    private static final String EXECUTOR_NAME_ATTRIBUTE = "executorName";
    private static final String EXECUTOR_CLASS_ATTRIBUTE = "executorClass";
    private static final String PEOPLE_FLOWS_SELECTED_ATTRIBUTE = "peopleFlowsSelected";
    private volatile Engine rulesEngine;
    private PeopleFlowRouteModule peopleFlowRouteModule;
    private ExtensionRepositoryService extensionRepositoryService;
    private RouteNodeService routeNodeService;

    @Override
    public List<ActionRequestValue> findActionRequests(RouteContext context) throws Exception {
        EngineResults engineResults = this.executeRulesEngine(context, this.getRulesEngine());
        if (engineResults != null) {
            this.processEngineResults(context, engineResults);
        }
        return this.peopleFlowRouteModule.findActionRequests(context);
    }

    @Override
    public ResponsibleParty resolveResponsibilityId(String responsibilityId) throws WorkflowException {
        return null;
    }

    @Override
    public boolean isMoreRequestsAvailable(RouteContext context) {
        return this.peopleFlowRouteModule.isMoreRequestsAvailable(context);
    }

    protected EngineResults executeRulesEngine(RouteContext context, Engine rulesEngine) {
        RulesEngineExecutor executor = this.loadRulesEngineExecutor(context);
        return executor.execute(context, rulesEngine);
    }

    protected void processEngineResults(RouteContext context, EngineResults engineResults) {
        String peopleFlowsSelected = (String)engineResults.getAttribute(PEOPLE_FLOWS_SELECTED_ATTRIBUTE);
        if (StringUtils.isBlank((String)peopleFlowsSelected)) {
            LOG.info("No PeopleFlows returned from KRMS execution.");
        } else {
            LOG.info("PeopleFlows returned from KRMS execution: " + peopleFlowsSelected);
        }
        NodeState nodeState = context.getNodeInstance().getNodeState("peopleFlowSequence");
        if (nodeState == null) {
            nodeState = new NodeState();
            nodeState.setNodeInstance(context.getNodeInstance());
            nodeState.setKey("peopleFlowSequence");
            context.getNodeInstance().addNodeState(nodeState);
        }
        nodeState.setValue(peopleFlowsSelected);
        if (!context.isSimulation()) {
            this.routeNodeService.save(nodeState);
        }
    }

    protected RulesEngineExecutor loadRulesEngineExecutor(RouteContext context) {
        ExtensionDefinition extensionDefinition;
        RouteNode routeNode = context.getNodeInstance().getRouteNode();
        Element rulesEngineElement = RouteNodeUtils.getCustomRouteNodeElement(context.getNodeInstance().getRouteNode(), RULES_ENGINE_ELEMENT);
        if (rulesEngineElement == null) {
            throw new ConfigurationException("Failed to located rules engine configuration for route node: " + routeNode.getName());
        }
        String executorName = rulesEngineElement.getAttribute(EXECUTOR_NAME_ATTRIBUTE);
        String executorClassName = rulesEngineElement.getAttribute(EXECUTOR_CLASS_ATTRIBUTE);
        if (StringUtils.isBlank((String)executorName) && StringUtils.isBlank((String)executorClassName)) {
            throw new ConfigurationException("Failed to resolve a valid executor name or class name from rules engine configuration, was null or blank.");
        }
        RulesEngineExecutor rulesEngineExecutor = null;
        if (StringUtils.isNotBlank((String)executorClassName)) {
            rulesEngineExecutor = (RulesEngineExecutor)GlobalResourceLoader.getObject((ObjectDefinition)new ObjectDefinition(executorClassName));
        } else if (StringUtils.isNotBlank((String)executorName) && (extensionDefinition = this.getExtensionRepositoryService().getExtensionByName(executorName)) != null) {
            rulesEngineExecutor = (RulesEngineExecutor)ExtensionUtils.loadExtension((ExtensionDefinitionContract)extensionDefinition);
        }
        if (rulesEngineExecutor == null) {
            throw new ConfigurationException("Failed to load RulesEngineExecutor for either executorName=" + executorName + " or executorClass=" + executorClassName);
        }
        return rulesEngineExecutor;
    }

    protected Engine getRulesEngine() {
        if (this.rulesEngine == null) {
            this.rulesEngine = KrmsApiServiceLocator.getEngine();
        }
        return this.rulesEngine;
    }

    public PeopleFlowRouteModule getPeopleFlowRouteModule() {
        return this.peopleFlowRouteModule;
    }

    public void setPeopleFlowRouteModule(PeopleFlowRouteModule peopleFlowRouteModule) {
        this.peopleFlowRouteModule = peopleFlowRouteModule;
    }

    public ExtensionRepositoryService getExtensionRepositoryService() {
        return this.extensionRepositoryService;
    }

    public void setExtensionRepositoryService(ExtensionRepositoryService extensionRepositoryService) {
        this.extensionRepositoryService = extensionRepositoryService;
    }

    public RouteNodeService getRouteNodeService() {
        return this.routeNodeService;
    }

    public void setRouteNodeService(RouteNodeService routeNodeService) {
        this.routeNodeService = routeNodeService;
    }
}

